export function formatTime(date: Date): string {
  const year = date.getFullYear();
  const month = date.getMonth() + 1;
  const day = date.getDate();
  const hour = date.getHours();
  const minute = date.getMinutes();
  const second = date.getSeconds();

  return (
    [year, month, day].map(formatNumber).join('-') +
    ' ' +
    [hour, minute, second].map(formatNumber).join(':')
  );
}

const formatNumber = (n: number) => {
  const str = n.toString();
  return str[1] ? str : '0' + str;
};

export const formatPrice = (n: number) => {
  const str = n.toFixed(2);
  let strArr = str.split('.');
  return joinComma(strArr[0]) + '.' + strArr[1];
};

const joinComma = (num: string) => {
  var result = [],
    counter = 0;
  for (let index = num.length - 1; index >= 0; index--) {
    counter++;
    if (index == 0 && isNaN(Number(num[index])) && result[0] === ',') {
      result.shift();
    }
    const element = num[index];
    result.unshift(element);
    if (!(counter % 3) && index != 0) {
      result.unshift(',');
    }
  }
  return result.join('');
};
export const delay = (function() {
  let timer = 0;
  return function(callback: () => void, ms: number) {
    clearTimeout(timer);
    timer = setTimeout(callback, ms);
  };
})();
