"use strict";
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var fetch_1 = require("../../api/fetch");
var util_1 = require("../../utils/util");
var app = getApp();
Page({
    onLoad: function () {
        this.initData();
        this.fetchAreaList();
    },
    data: {
        month: '',
        areaId: '',
        areaName: '',
        areaList: [],
        growthList: [],
        activateList: [],
        registerCount: 0,
        customerCount: 0,
        activeCount: 0,
        isAdmin: 0,
    },
    initData: function () {
        var _this = this;
        var time = util_1.formatTime(new Date());
        console.log(time);
        console.log(app.globalData.userRoles);
        this.setData({
            userInfo: app.globalData.userInfo,
        });
        var isAdmin = 0;
        var registerRoute = app.globalData.userRoles.find(function (item) { return item.menuCode === '0083'; });
        if (registerRoute &&
            registerRoute.listMenuButtonVo &&
            registerRoute.listMenuButtonVo.length) {
            if (registerRoute.listMenuButtonVo.find(function (item) { return item.buttonCode === '0001'; }))
                isAdmin = 1;
        }
        this.setData({ month: time.slice(0, 7), isAdmin: isAdmin }, function () {
            _this.fetchList();
        });
    },
    fetchAreaList: function () {
        var _this = this;
        fetch_1.baseFetch({
            url: '/dcxy/baseArea/queryAll',
        })
            .then(function (res) {
            if (res.data) {
                _this.setData({
                    areaList: res.data,
                });
            }
            else {
                _this.setData({
                    areaList: [],
                });
            }
        })
            .catch(function (err) {
            console.log(err);
        });
    },
    fetchList: function (entity) {
        if (this.data.areaId) {
            if (entity && entity.areaId) {
            }
            else
                entity = __assign({}, entity, { areaId: this.data.areaId });
        }
        this.fetchUserData(entity);
    },
    fetchUserData: function (entity) {
        var _this = this;
        var monthString = entity && entity.monthString ? entity.monthString : this.data.month;
        var _a = monthString.split('-'), year = _a[0], month = _a[1];
        var reqBody = __assign({ year: year,
            month: month, isAdmin: this.data.isAdmin }, entity);
        fetch_1.statisticsFetch({
            url: '/dcxy/reportInfo/boss/queryReportList',
            data: reqBody,
        })
            .then(function (res) {
            console.log(res);
            var _a = res.data, customerCount = _a.customerCount, dayVos = _a.dayVos, activeCount = _a.activeCount, dayAcs = _a.dayAcs;
            var dayList = new Array(31)
                .fill({
                count: 0,
            })
                .map(function (v, idx) { return (__assign({}, v, { days: idx + 1 })); });
            if (dayVos && dayVos.length) {
                var oList = dayVos;
                for (var index = 0; index < oList.length; index++) {
                    var element = oList[index];
                    var daysIndex = Number(element.days.slice(-2));
                    if (dayList[daysIndex - 1].count) {
                        dayList[daysIndex - 1] = __assign({}, dayList[daysIndex - 1], { count: dayList[daysIndex - 1].count + element.count });
                    }
                    else {
                        dayList[daysIndex - 1] = __assign({}, dayList[daysIndex - 1], { count: element.count });
                    }
                }
            }
            var activateList = new Array(31)
                .fill({
                count: 0,
            })
                .map(function (v, idx) { return (__assign({}, v, { days: idx + 1 })); });
            if (dayAcs && dayAcs.length) {
                var oList = dayAcs;
                for (var index = 0; index < oList.length; index++) {
                    var element = oList[index];
                    var daysIndex = Number(element.days.slice(-2));
                    if (activateList[daysIndex - 1].count) {
                        activateList[daysIndex - 1] = __assign({}, activateList[daysIndex - 1], { count: activateList[daysIndex - 1].count + element.count });
                    }
                    else {
                        activateList[daysIndex - 1] = __assign({}, activateList[daysIndex - 1], { count: element.count });
                    }
                }
            }
            var registerCount = dayVos.reduce(function (total, current) { return (total += current.count); }, 0);
            console.log('dayList:', dayList);
            _this.setData({
                growthList: dayList,
                activateList: activateList,
                registerCount: registerCount,
                customerCount: customerCount ? customerCount : 0,
                activeCount: activeCount ? activeCount : 0,
            });
        })
            .catch(function (err) {
            console.log(err);
        });
    },
    areaChangeHandle: function (val) {
        var _this = this;
        console.log('areaChangeHandle', val);
        var id = val.id, name = val.name;
        this.setData({
            areaId: id,
            areaName: name,
        }, function () {
            if (id) {
                _this.fetchList({ areaId: id });
            }
            else {
                _this.fetchList();
            }
        });
    },
    monthChangeHandle: function (val) {
        console.log('monthChangeHandle', val);
        var value = val.detail.value;
        this.fetchList({ monthString: value });
        this.setData({
            month: value,
        });
    },
});
//# sourceMappingURL=data:application/json;base64,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