import { statisticsFetch } from '../../api/fetch';
import { formatTime } from '../../utils/util';

Page({
  onLoad() {
    this.initData();
  },
  data: {
    month: '',
    areaId: '',
    areaName: '',
    rechargeData: {
      title: '充值总额',
      numberType: 'price',
      count: 0,
    },
    rechargeCount: {
      title: '充值笔数',
      numberType: '',
      count: 0,
    },
    rechargeAndRefundList: [],
    consumeData: {
      title: '消费总额',
      numberType: 'price',
      count: 0,
    },
    consumeCount: {
      title: '消费笔数',
      numberType: '',
      count: 0,
    },
    consumeList: [],
    serviceTypeList: [],
    payTypeList: [],
  },
  initData() {
    let time = formatTime(new Date());
    console.log(time);
    this.setData!({ month: time.slice(0, 7) }, () => {
      this.fetchList();
    });
  },
  areaChangeHandle(val) {
    console.log('areaChangeHandle', val);
    const { id, name } = val;
    this.setData!(
      {
        areaId: id,
        areaName: name,
      },
      () => {
        if (id) {
          this.fetchList({ areaId: [id] });
        } else {
          this.fetchList();
        }
      },
    );
  },
  monthChangeHandle(val) {
    console.log('monthChangeHandle', val);
    const { value } = val.detail;
    this.fetchList({ month: value });
    this.setData!({
      month: value,
    });
  },
  fetchList(entity?: { areaId?: number; month?: string }) {
    if (this.data.areaId) {
      if (entity && entity.areaId) {
      } else entity = { ...entity, areaId: [this.data.areaId] };
    }
    console.log(this.data.areaId, entity);
    this.fetchRechargeData(entity);
    this.fetchConsumeData(entity);
    this.fetchServiceTypeList(entity);
    this.fetchPayTypeList(entity);
  },
  fetchConsumeData(entity?: { areaId?: number; month?: string }) {
    let reqBody = {
      month: this.data.month,
      ...entity,
    };
    statisticsFetch({
      url: '/dcxy/reportInfo/dailyConsumeCount',
      method: 'POST',
      data: reqBody,
    })
      .then(res => {
        let dayList = new Array(31)
          .fill({
            payMen: 0,
            payableMoney: 0,
          })
          .map((v, idx) => ({ ...v, days: idx + 1 }));

        let consumePrice = 0;
        let consumeCount = 0;
        if (res.data && res.data.length) {
          let oList = res.data;
          for (let index = 0; index < oList.length; index++) {
            const element = oList[index];
            consumePrice += element.payableMoney;
            consumeCount += element.payMen;
            let daysIndex = Number(element.createDate.slice(-2));
            dayList[daysIndex - 1] = {
              ...dayList[daysIndex - 1],
              payMen: element.payMen,
              payableMoney: element.payableMoney,
            };
          }
        }
        this.setData!({
          consumeList: dayList,
          'consumeData.count': consumePrice,
          'consumeCount.count': consumeCount,
        });
      })
      .catch(err => {
        console.log(err);
      });
  },
  fetchRechargeData(entity?: { areaId?: number; month?: string }) {
    let reqBody = {
      month: this.data.month,
      ...entity,
    };
    statisticsFetch({
      url: '/dcxy/reportInfo/queryRechargeListDaily',
      method: 'POST',
      data: reqBody,
    })
      .then(res => {
        let dayList = new Array(31)
          .fill({
            rechargeMoney: 0,
            rechargeMen: 0,
            refundCount: 0,
            refundMoney: 0,
          })
          .map((v, idx) => ({ ...v, days: idx + 1 }));
        let rechargePrice = 0;
        let rechargeCount = 0;
        if (res.data && res.data.length) {
          let oList = res.data;
          for (let index = 0; index < oList.length; index++) {
            const element = oList[index];
            rechargePrice += element.rechargeMoney;
            rechargeCount += element.rechargeMen;
            let daysIndex = Number(element.completeAt.slice(-2));
            dayList[daysIndex - 1] = {
              ...dayList[daysIndex - 1],
              rechargeMoney: element.rechargeMoney,
              rechargeMen: element.rechargeMen,
              refundCount: element.refundCount,
              refundMoney: element.refundMoney,
            };
          }
        }
        console.log(dayList);
        this.setData!({
          rechargeAndRefundList: dayList,
          'rechargeData.count': rechargePrice,
          'rechargeCount.count': rechargeCount,
        });
      })
      .catch(err => {
        console.log(err);
      });
  },
  fetchServiceTypeList(entity) {
    let reqBody = {
      month: this.data.month,
      ...entity,
    };
    statisticsFetch({
      url: '/dcxy/reportInfo/queryConsumeOrderList',
      method: 'POST',
      data: reqBody,
    })
      .then(res => {
        console.log(res);
        this.setData!({
          serviceTypeList: res.data,
        });
      })
      .catch(err => {
        console.log(err);
      });
  },
  fetchPayTypeList(entity) {
    let reqBody = {
      month: this.data.month,
      ...entity,
    };
    statisticsFetch({
      url: '/dcxy/reportInfo/payTypeConsume',
      method: 'POST',
      data: reqBody,
    })
      .then(res => {
        console.log(res);
        if (res.data) {
          const keyMap = {
            aimi: '艾米',
            bean: '消费豆',
            discount: '优惠金额',
            online: '线上支付',
          };
          let dataList = Object.keys(res.data).map(key => ({
            key,
            a: 'payType',
            name: keyMap[key],
            count: res.data[key],
          }));
          this.setData!({
            payTypeList: dataList,
          });
        }
      })
      .catch(err => {
        console.log(err);
      });
  },
});
