"use strict";
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var fetch_1 = require("../../api/fetch");
var util_1 = require("../../utils/util");
Page({
    onLoad: function () {
        this.initData();
    },
    data: {
        month: '',
        areaId: '',
        areaName: '',
        rechargeData: {
            title: '充值总额',
            numberType: 'price',
            count: 0,
        },
        rechargeCount: {
            title: '充值笔数',
            numberType: '',
            count: 0,
        },
        rechargeAndRefundList: [],
        consumeData: {
            title: '消费总额',
            numberType: 'price',
            count: 0,
        },
        consumeCount: {
            title: '消费笔数',
            numberType: '',
            count: 0,
        },
        consumeList: [],
        serviceTypeList: [],
        payTypeList: [],
    },
    initData: function () {
        var _this = this;
        var time = util_1.formatTime(new Date());
        console.log(time);
        this.setData({ month: time.slice(0, 7) }, function () {
            _this.fetchList();
        });
    },
    areaChangeHandle: function (val) {
        var _this = this;
        console.log('areaChangeHandle', val);
        var id = val.id, name = val.name;
        this.setData({
            areaId: id,
            areaName: name,
        }, function () {
            if (id) {
                _this.fetchList({ areaId: [id] });
            }
            else {
                _this.fetchList();
            }
        });
    },
    monthChangeHandle: function (val) {
        console.log('monthChangeHandle', val);
        var value = val.detail.value;
        this.fetchList({ month: value });
        this.setData({
            month: value,
        });
    },
    fetchList: function (entity) {
        if (this.data.areaId) {
            if (entity && entity.areaId) {
            }
            else
                entity = __assign({}, entity, { areaId: [this.data.areaId] });
        }
        console.log(this.data.areaId, entity);
        this.fetchRechargeData(entity);
        this.fetchConsumeData(entity);
        this.fetchServiceTypeList(entity);
        this.fetchPayTypeList(entity);
    },
    fetchConsumeData: function (entity) {
        var _this = this;
        var reqBody = __assign({ month: this.data.month }, entity);
        fetch_1.statisticsFetch({
            url: '/dcxy/reportInfo/dailyConsumeCount',
            method: 'POST',
            data: reqBody,
        })
            .then(function (res) {
            var dayList = new Array(31)
                .fill({
                payMen: 0,
                payableMoney: 0,
            })
                .map(function (v, idx) { return (__assign({}, v, { days: idx + 1 })); });
            var consumePrice = 0;
            var consumeCount = 0;
            if (res.data && res.data.length) {
                var oList = res.data;
                for (var index = 0; index < oList.length; index++) {
                    var element = oList[index];
                    consumePrice += element.payableMoney;
                    consumeCount += element.payMen;
                    var daysIndex = Number(element.createDate.slice(-2));
                    dayList[daysIndex - 1] = __assign({}, dayList[daysIndex - 1], { payMen: element.payMen, payableMoney: element.payableMoney });
                }
            }
            _this.setData({
                consumeList: dayList,
                'consumeData.count': consumePrice,
                'consumeCount.count': consumeCount,
            });
        })
            .catch(function (err) {
            console.log(err);
        });
    },
    fetchRechargeData: function (entity) {
        var _this = this;
        var reqBody = __assign({ month: this.data.month }, entity);
        fetch_1.statisticsFetch({
            url: '/dcxy/reportInfo/queryRechargeListDaily',
            method: 'POST',
            data: reqBody,
        })
            .then(function (res) {
            var dayList = new Array(31)
                .fill({
                rechargeMoney: 0,
                rechargeMen: 0,
                refundCount: 0,
                refundMoney: 0,
            })
                .map(function (v, idx) { return (__assign({}, v, { days: idx + 1 })); });
            var rechargePrice = 0;
            var rechargeCount = 0;
            if (res.data && res.data.length) {
                var oList = res.data;
                for (var index = 0; index < oList.length; index++) {
                    var element = oList[index];
                    rechargePrice += element.rechargeMoney;
                    rechargeCount += element.rechargeMen;
                    var daysIndex = Number(element.completeAt.slice(-2));
                    dayList[daysIndex - 1] = __assign({}, dayList[daysIndex - 1], { rechargeMoney: element.rechargeMoney, rechargeMen: element.rechargeMen, refundCount: element.refundCount, refundMoney: element.refundMoney });
                }
            }
            console.log(dayList);
            _this.setData({
                rechargeAndRefundList: dayList,
                'rechargeData.count': rechargePrice,
                'rechargeCount.count': rechargeCount,
            });
        })
            .catch(function (err) {
            console.log(err);
        });
    },
    fetchServiceTypeList: function (entity) {
        var _this = this;
        var reqBody = __assign({ month: this.data.month }, entity);
        fetch_1.statisticsFetch({
            url: '/dcxy/reportInfo/queryConsumeOrderList',
            method: 'POST',
            data: reqBody,
        })
            .then(function (res) {
            console.log(res);
            _this.setData({
                serviceTypeList: res.data,
            });
        })
            .catch(function (err) {
            console.log(err);
        });
    },
    fetchPayTypeList: function (entity) {
        var _this = this;
        var reqBody = __assign({ month: this.data.month }, entity);
        fetch_1.statisticsFetch({
            url: '/dcxy/reportInfo/payTypeConsume',
            method: 'POST',
            data: reqBody,
        })
            .then(function (res) {
            console.log(res);
            if (res.data) {
                var keyMap_1 = {
                    aimi: '艾米',
                    bean: '消费豆',
                    discount: '优惠金额',
                    online: '线上支付',
                };
                var dataList = Object.keys(res.data).map(function (key) { return ({
                    key: key,
                    a: 'payType',
                    name: keyMap_1[key],
                    count: res.data[key],
                }); });
                _this.setData({
                    payTypeList: dataList,
                });
            }
        })
            .catch(function (err) {
            console.log(err);
        });
    },
});
//# sourceMappingURL=data:application/json;base64,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