"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var fetch_1 = require("../../api/fetch");
var util_1 = require("../../utils/util");
Component({
    lifetimes: {
        attached: function () {
            console.log('in show ', this.data.fetched);
            !this.data.fetched && this.fetchRechargeData();
        },
    },
    data: {
        timeType: 0,
        fetched: false,
        serviceList: [],
        rechargeData: {
            title: '充值总额',
            numberType: 'price',
            count: 0,
        },
        rechargeCount: {
            title: '充值总笔数',
            numberType: '',
            count: 0,
        },
        onlineRechargeData: {
            title: '线上充值',
            numberType: '1',
            count: 0,
            price: 0,
        },
        offlineRechargeData: {
            title: '线下充值',
            numberType: '1',
            count: 0,
            price: 0,
        },
        comsumerData: {
            title: '消费总额',
            numberType: 'price',
            count: 0,
        },
        comsumerCount: {
            title: '消费总笔数',
            numberType: '',
            count: 0,
        },
        refundData: {
            title: '退款总额',
            numberType: 'price',
            count: 0,
        },
        refundCount: {
            title: '退款总笔数',
            numberType: '',
            count: 0,
        },
        testData: {
            title: '充值总额',
            numberType: 'price',
            count: 0,
        },
        testData2: {
            title: '线上充值',
            numberType: '1',
            count: 0,
            price: 0,
        },
    },
    methods: {
        changeTimeType: function (e) {
            var timetype = e.currentTarget.dataset.timetype;
            if (timetype === this.data.timeType)
                return;
            this.setData({
                timeType: timetype,
            });
            this.fetchRechargeData(timetype);
            return false;
        },
        fetchRechargeData: function (timeType) {
            var _this = this;
            if (!timeType)
                timeType = this.data.timeType;
            var today = util_1.formatTime(new Date());
            var date = today.split(' ')[0];
            var entity = {
                timeType: timeType,
            };
            if (timeType === 0) {
                entity.date = date;
            }
            else if (timeType === 1) {
                entity.month = date.slice(0, 7);
            }
            else if (timeType === 2) {
                entity.year = date.slice(0, 4);
            }
            wx.showLoading({ title: '', mask: true });
            var rechargeDataFetch = fetch_1.statisticsFetch({
                url: '/dcxy/reportInfo/queryRechargeOrderListV2',
                method: 'POST',
                data: entity,
            }).then(function (res) {
                var data = res.rechargeOrderCountVo;
                if (data) {
                    var rechargeMen = data.rechargeMen, rechargeMoney = data.rechargeMoney, refundCount = data.refundCount, refundMoney = data.refundMoney, offlineRechargeMen = data.offlineRechargeMen, offlineRechargeMoney = data.offlineRechargeMoney, onlineRechargeMen = data.onlineRechargeMen, onlineRechargeMoney = data.onlineRechargeMoney;
                    _this.setData({
                        'rechargeData.count': rechargeMoney,
                        'rechargeCount.count': rechargeMen,
                        'refundData.count': refundMoney,
                        'refundCount.count': refundCount,
                        'onlineRechargeData.price': onlineRechargeMoney,
                        'onlineRechargeData.count': onlineRechargeMen,
                        'offlineRechargeData.price': offlineRechargeMoney,
                        'offlineRechargeData.count': offlineRechargeMen,
                    });
                }
                else {
                    _this.setData({
                        'rechargeData.count': 0,
                        'rechargeCount.count': 0,
                        'refundData.count': 0,
                        'refundCount.count': 0,
                        'onlineRechargeData.price': 0,
                        'onlineRechargeData.count': 0,
                        'offlineRechargeData.price': 0,
                        'offlineRechargeData.count': 0,
                    });
                }
            });
            var consumeDataFetch = fetch_1.statisticsFetch({
                url: '/dcxy/reportInfo/queryConsumeOrderList',
                method: 'POST',
                data: entity,
            }).then(function (res) {
                var consumeCountVo = res.consumeCountVo, data = res.data;
                console.log(res);
                _this.setData({
                    serviceList: data.map(function (item) { return ({
                        serviceId: item.serviceId,
                        title: item.serviceName,
                        numberType: '1',
                        count: item.payMen,
                        price: item.payableMoney,
                    }); }),
                    'comsumerData.count': consumeCountVo && consumeCountVo.payableMoney
                        ? consumeCountVo.payableMoney
                        : 0,
                    'comsumerCount.count': consumeCountVo && consumeCountVo.payMen ? consumeCountVo.payMen : 0,
                });
            });
            Promise.all([consumeDataFetch, rechargeDataFetch])
                .then(function () {
                wx.hideLoading();
            })
                .catch(function (err) {
                wx.hideLoading();
                wx.showToast({
                    title: err.errMsg,
                    icon: 'none',
                });
                console.log(err);
            });
        },
    },
});
//# sourceMappingURL=data:application/json;base64,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