// pages/components/UserGrouthChart/UserGrouthChart.js
let userGrouthChart = null;
let month = '';

function initChart(canvas, width, height, F2) {
  const data = [];
  userGrouthChart = new F2.Chart({
    el: canvas,
    width,
    height,
  });

  userGrouthChart.source(data, {
    days: {
      min: 1,
      max: 31,
    },
  });
  userGrouthChart.tooltip({
    showItemMarker: false,
    background: {
      radius: 2,
      fill: '#6895fe',
      padding: [6, 10],
    },
    onShow(ev) {
      const { items } = ev;
      items[0].name = '';
      items[0].value = month + '-' + items[0].title;
      items[1].name = '';
      items[1].value = items[1].value + '人';
    },
  });
  userGrouthChart
    .line()
    .position('days*count')
    .color('#6895fe')
    .shape('smooth')
    .size(4);
  userGrouthChart
    .area()
    .position('days*count')
    .color('l(90) 0:#6895fe 1:#fff')
    .shape('smooth')
    .style({
      fillOpacity: 0.6,
    });
  // userGrouthChart.axis('count', false);
  userGrouthChart.render();
  return userGrouthChart;
}

Component({
  properties: {
    dataList: {
      type: Array,
      value: [],
      observer(newVal) {
        userGrouthChart && userGrouthChart.changeData(newVal);
      },
    },
    month: {
      type: String,
      value: '',
      observer(newVal) {
        month = newVal;
      },
    },
  },
  data: {
    opts: {
      onInit: initChart,
    },
  },
});

