"use strict";
var userGrouthChart = null;
var month = '';
function initChart(canvas, width, height, F2) {
    var data = [];
    userGrouthChart = new F2.Chart({
        el: canvas,
        width: width,
        height: height,
    });
    userGrouthChart.source(data, {
        days: {
            min: 1,
            max: 31,
        },
    });
    userGrouthChart.tooltip({
        showItemMarker: false,
        background: {
            radius: 2,
            fill: '#6895fe',
            padding: [6, 10],
        },
        onShow: function (ev) {
            var items = ev.items;
            items[0].name = '';
            items[0].value = month + '-' + items[0].title;
            items[1].name = '';
            items[1].value = items[1].value + '人';
        },
    });
    userGrouthChart
        .line()
        .position('days*count')
        .color('#6895fe')
        .shape('smooth')
        .size(4);
    userGrouthChart
        .area()
        .position('days*count')
        .color('l(90) 0:#6895fe 1:#fff')
        .shape('smooth')
        .style({
        fillOpacity: 0.6,
    });
    userGrouthChart.render();
    return userGrouthChart;
}
Component({
    properties: {
        dataList: {
            type: Array,
            value: [],
            observer: function (newVal) {
                userGrouthChart && userGrouthChart.changeData(newVal);
            },
        },
        month: {
            type: String,
            value: '',
            observer: function (newVal) {
                month = newVal;
            },
        },
    },
    data: {
        opts: {
            onInit: initChart,
        },
    },
});
//# sourceMappingURL=data:application/json;base64,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