// pages/components/UserActivityChart/UserActivityChart.js
let userActivityChart = null;
let month = '';

function initChart(canvas, width, height, F2) {
  const data = [];
  userActivityChart = new F2.Chart({
    el: canvas,
    width,
    height,
  });

  userActivityChart.source(data, {
    days: {
      min: 1,
      max: 31,
    },
  });
  userActivityChart.tooltip({
    showItemMarker: false,
    background: {
      radius: 2,
      fill: '#6895fe',
      padding: [6, 10],
    },
    onShow(ev) {
      const { items } = ev;
      items[0].name = '';
      items[0].value = month + '-' + items[0].title;
      items[1].name = '';
      items[1].value = items[1].value + '人';
    },
  });
  userActivityChart
    .line()
    .position('days*count')
    .color('#6895fe')
    .shape('smooth')
    .size(4);
  userActivityChart
    .area()
    .position('days*count')
    .color('l(90) 0:#6895fe 1:#fff')
    .shape('smooth')
    .style({
      fillOpacity: 0.6,
    });
  // userActivityChart.axis('count', false);
  userActivityChart.render();
  return userActivityChart;
}

Component({
  properties: {
    dataList: {
      type: Array,
      value: [],
      observer(newVal) {
        userActivityChart && userActivityChart.changeData(newVal);
      },
    },
    month: {
      type: String,
      value: '',
      observer(newVal) {
        month = newVal;
      },
    },
  },
  data: {
    opts: {
      onInit: initChart,
    },
  },
});
