"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var util_1 = require("../../../utils/util");
Component({
    properties: {
        tagData: {
            type: Object,
            value: {
                title: '',
                numberType: '',
                count: 0,
                price: 0,
            },
            observer: function (newVal) {
                var price = newVal.price;
                var formatCount = util_1.formatPrice(price);
                this.setData({
                    formatCount: formatCount,
                });
            },
        },
    },
    data: {
        formatCount: '0.00',
    },
    methods: {},
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiU2VydmljZUNvdW50LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiU2VydmljZUNvdW50LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsNENBQWtEO0FBR2xELFNBQVMsQ0FBQztJQUlSLFVBQVUsRUFBRTtRQUNWLE9BQU8sRUFBRTtZQUNQLElBQUksRUFBRSxNQUFNO1lBQ1osS0FBSyxFQUFFO2dCQUNMLEtBQUssRUFBRSxFQUFFO2dCQUNULFVBQVUsRUFBRSxFQUFFO2dCQUNkLEtBQUssRUFBRSxDQUFDO2dCQUNSLEtBQUssRUFBRSxDQUFDO2FBQ1Q7WUFDRCxRQUFRLEVBQUUsVUFBUyxNQUFNO2dCQUNmLElBQUEsb0JBQUssQ0FBWTtnQkFDekIsSUFBSSxXQUFXLEdBQUcsa0JBQVcsQ0FBQyxLQUFLLENBQUMsQ0FBQztnQkFDckMsSUFBSSxDQUFDLE9BQU8sQ0FBQztvQkFDWCxXQUFXLGFBQUE7aUJBQ1osQ0FBQyxDQUFDO1lBQ0wsQ0FBQztTQUNGO0tBQ0Y7SUFJRCxJQUFJLEVBQUU7UUFDSixXQUFXLEVBQUUsTUFBTTtLQUNwQjtJQUtELE9BQU8sRUFBRSxFQUFFO0NBQ1osQ0FBQyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgZm9ybWF0UHJpY2UgfSBmcm9tICcuLi8uLi8uLi91dGlscy91dGlsJztcblxuLy8gcGFnZXMvY29tcG9uZW50cy9TZXJ2aWNlQ291bnQvU2VydmljZUNvdW50LmpzXG5Db21wb25lbnQoe1xuICAvKipcbiAgICog57uE5Lu255qE5bGe5oCn5YiX6KGoXG4gICAqL1xuICBwcm9wZXJ0aWVzOiB7XG4gICAgdGFnRGF0YToge1xuICAgICAgdHlwZTogT2JqZWN0LFxuICAgICAgdmFsdWU6IHtcbiAgICAgICAgdGl0bGU6ICcnLFxuICAgICAgICBudW1iZXJUeXBlOiAnJyxcbiAgICAgICAgY291bnQ6IDAsXG4gICAgICAgIHByaWNlOiAwLFxuICAgICAgfSxcbiAgICAgIG9ic2VydmVyOiBmdW5jdGlvbihuZXdWYWwpIHtcbiAgICAgICAgY29uc3QgeyBwcmljZSB9ID0gbmV3VmFsO1xuICAgICAgICBsZXQgZm9ybWF0Q291bnQgPSBmb3JtYXRQcmljZShwcmljZSk7XG4gICAgICAgIHRoaXMuc2V0RGF0YSh7XG4gICAgICAgICAgZm9ybWF0Q291bnQsXG4gICAgICAgIH0pO1xuICAgICAgfSxcbiAgICB9LFxuICB9LFxuICAvKipcbiAgICog57uE5Lu255qE5Yid5aeL5pWw5o2uXG4gICAqL1xuICBkYXRhOiB7XG4gICAgZm9ybWF0Q291bnQ6ICcwLjAwJyxcbiAgfSxcblxuICAvKipcbiAgICog57uE5Lu255qE5pa55rOV5YiX6KGoXG4gICAqL1xuICBtZXRob2RzOiB7fSxcbn0pO1xuIl19