"use strict";
Component({
    properties: {
        placeholder: {
            type: String,
            value: '请选择',
        },
        range: {
            type: Array,
            value: [],
        },
        rangeKey: {
            type: String,
            value: 'key',
        },
        mode: {
            type: String,
            value: 'selector',
        },
        fields: {
            type: String,
            value: 'day',
        },
        value: {
            type: String,
            value: '',
            observer: function (newVal) {
                console.log('in select ob', newVal);
                this.setData({ selected: newVal });
            },
        },
    },
    data: {
        selected: '',
    },
    methods: {
        bindPickerChange: function (e) {
            var value = e.detail.value;
            console.log(value);
            this.setData({
                selected: value,
            });
            this.triggerEvent('change', { value: value });
        },
    },
});
//# sourceMappingURL=data:application/json;base64,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