import { customerFetch } from '../../../api/fetch';

// pages/components/FeedbackItem/FeedbackItem.ts
Component({
  /**
   * 组件的属性列表
   */
  properties: {
    feedbackData: {
      type: Object,
      value: {
        areaId: 0,
        areaName: '',
        customerId: 0,
        customerName: '',
        customerPhone: '',
        customerSex: '',
        feedbackContent: '',
        id: 0,
        state: '',
      },
    },
  },

  /**
   * 组件的初始数据
   */
  data: {
    inputValue: '',
  },

  /**
   * 组件的方法列表
   */
  methods: {
    makePhoneCallHandle() {
      console.log('in makePhoneCallHandle');
      wx.makePhoneCall({
        phoneNumber: this.data.feedbackData.customerPhone,
        success: () => {
          console.log('success');
        },
        fail: () => {
          console.log('fail');
        },
      });
    },
    inputHandle(e) {
      const val = e.detail.value;
      this.setData({
        inputValue: val,
      });
    },

    sendFeedback() {
      const val = this.data.inputValue;

      customerFetch({
        url: '/feedback/feedback',
        method: 'PUT',
        data: {
          id: this.data.feedbackData.id,
          replayContent: val,
          state: '3',
        },
      })
        .then(res => {
          wx.showToast({
            title: res.msg,
          });
          this.setData({
            inputValue: '',
          });
          this.triggerEvent('refresh', {});
        })
        .catch((err: wx.GeneralCallbackResult) => {
          wx.showToast({
            title: err.errMsg,
            icon: 'none',
          });
        });
    },
  },
});
