"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var fetch_1 = require("../../../api/fetch");
Component({
    properties: {
        feedbackData: {
            type: Object,
            value: {
                areaId: 0,
                areaName: '',
                customerId: 0,
                customerName: '',
                customerPhone: '',
                customerSex: '',
                feedbackContent: '',
                id: 0,
                state: '',
            },
        },
    },
    data: {
        inputValue: '',
    },
    methods: {
        makePhoneCallHandle: function () {
            console.log('in makePhoneCallHandle');
            wx.makePhoneCall({
                phoneNumber: this.data.feedbackData.customerPhone,
                success: function () {
                    console.log('success');
                },
                fail: function () {
                    console.log('fail');
                },
            });
        },
        inputHandle: function (e) {
            var val = e.detail.value;
            this.setData({
                inputValue: val,
            });
        },
        sendFeedback: function () {
            var _this = this;
            var val = this.data.inputValue;
            fetch_1.customerFetch({
                url: '/feedback/feedback',
                method: 'PUT',
                data: {
                    id: this.data.feedbackData.id,
                    replayContent: val,
                    state: '3',
                },
            })
                .then(function (res) {
                wx.showToast({
                    title: res.msg,
                });
                _this.setData({
                    inputValue: '',
                });
                _this.triggerEvent('refresh', {});
            })
                .catch(function (err) {
                wx.showToast({
                    title: err.errMsg,
                    icon: 'none',
                });
            });
        },
    },
});
//# sourceMappingURL=data:application/json;base64,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