"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var util_1 = require("../../../utils/util");
Component({
    properties: {
        placeholder: {
            type: String,
            value: '请选择',
        },
        range: {
            type: Array,
            value: [],
            observer: function (newVal) {
                this.setData({ filterList: newVal });
            },
        },
        rangeKey: {
            type: String,
            value: 'key',
        },
        value: {
            type: String,
            value: '',
            observer: function (newVal) {
                console.log(newVal);
                this.setData({ selected: newVal });
            },
        },
        mode: {
            type: String,
            value: 'selector',
        },
        methodName: {
            type: String,
            value: '',
        },
        showText: {
            type: String,
            value: '',
            observer: function (val) {
                console.log('in showText', val);
            },
        },
    },
    data: {
        showPickerView: false,
        selected: '',
        selectedIndex: '',
        filterList: [],
        inputValue: '',
    },
    methods: {
        inputClickHandle: function () {
            if (this.data.mode === 'page') {
                wx.navigateTo({
                    url: "/pages/areaSelect/areaSelect?methodName=" + this.data.methodName + "&value=" + this.data.value,
                });
            }
            else {
                var inputValue = '';
                if (this.data.selectedIndex || this.data.selectedIndex === 0) {
                    inputValue = this.data.range[this.data.selectedIndex].areaName;
                }
                console.log(inputValue);
                this.setData({
                    showPickerView: !this.data.showPickerView,
                    inputValue: inputValue,
                });
            }
        },
        clearInputValue: function () {
            console.log('in clearInputValue');
            this.setData({
                inputValue: '',
                selected: '',
                selectedIndex: '',
            });
        },
        innerClickHandle: function (e) {
            return false;
        },
        maskClickHandle: function (e) {
            this.setData({
                showPickerView: false,
            });
            return false;
        },
        inputHandle: function (e) {
            var _this = this;
            var value = e.detail.value;
            console.log(e, value);
            util_1.delay(function () {
                _this.getFilterListByName(value);
            }, 500);
        },
        confirmHandle: function (e) {
            var value = e.detail.value;
            console.log(e, value);
            this.getFilterListByName(value);
        },
        getFilterListByName: function (name) {
            var _this = this;
            var filterList = [];
            if (name) {
                filterList = this.data.range.filter(function (item) {
                    return item[_this.data.rangeKey].includes(name);
                });
            }
            else {
                filterList = this.data.range;
            }
            this.setData({
                filterList: filterList,
            });
        },
        bindPickerChange: function () {
            var value = this.data.selected;
            this.setData({
                showPickerView: false,
            });
            this.triggerEvent('change', { value: value }, {});
        },
        selectedHandle: function (e) {
            var value = e.currentTarget.dataset.value;
            console.log(e, value);
            var valueId = this.data.filterList[value].id;
            this.setData({
                showPickerView: false,
                selected: this.data.filterList[value].id,
                selectedIndex: value,
            });
            this.triggerEvent('change', { value: valueId }, {});
        },
    },
});
//# sourceMappingURL=data:application/json;base64,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