import { baseFetch } from '../../api/fetch';
import { delay } from '../../utils/util';

// miniprogram/pages/areaSelect/areaSelect.js
Page({
  /**
   * 页面的初始数据
   */
  data: {
    selected: '',
    selectedIndex: '',
    areaList: [],
    filterList: [],
    methodName: '',
    inputValue: '',
  },

  /**
   * 生命周期函数--监听页面加载
   */
  onLoad: function(options) {
    console.log(options);
    const { methodName, value } = options;
    this.fetchAreaList();
    this.setData!({
      methodName,
      selected: value,
    });
  },
  /**
   * 生命周期函数--监听页面显示
   */
  onShow: function() {},
  fetchAreaList() {
    baseFetch({
      url: '/dcxy/baseArea/queryAll',
    })
      .then(res => {
        if (res.data) {
          this.setData!({
            areaList: res.data,
            filterList: res.data,
          });
          if (this.data.selected) {
            let index = res.data.findIndex(
              item => item.id == this.data.selected,
            );
            console.log(this.data.selected, index);
            if (index > -1) {
              this.setData({
                selectedIndex: index,
                inputValue: res.data[index].areaName,
              });
            }
          }
        } else {
          this.setData!({
            areaList: [],
            filterList: [],
          });
        }
      })
      .catch(err => {
        console.log(err);
      });
  },
  inputHandle(e) {
    const { value } = e.detail;
    console.log(e, value);
    delay(() => {
      this.getFilterListByName(value);
    }, 500);
  },
  confirmHandle(e) {
    const { value } = e.detail;
    console.log(e, value);
    this.getFilterListByName(value);
  },
  clearInputValue() {
    console.log('in clearInputValue');
    this.setData!({
      inputValue: '',
      selected: '',
      selectedIndex: '',
    });
  },
  getFilterListByName(name: string) {
    let filterList = [];
    if (name) {
      filterList = this.data.areaList.filter(item =>
        item['areaName'].includes(name),
      );
    } else {
      filterList = this.data.areaList;
    }
    this.setData!({
      filterList,
    });
  },
  selectedHandle(e) {
    const { value } = e.currentTarget.dataset;
    console.log(e, value);
    // if (this.data.selectedIndex === value) {
    //   this.setData({
    //     selected: '',
    //     selectedIndex: '',
    //   });
    // } else {
    //   this.setData({
    //     selected: this.data.filterList[value].id,
    //     selectedIndex: value,
    //   });
    // }
    var pages = getCurrentPages();
    var prevPage = pages[pages.length - 2]; //上一个页面
    let entity = {
      id: this.data.filterList[value].id,
      name: this.data.filterList[value].areaName,
    };

    if (this.data.methodName && prevPage[this.data.methodName]) {
      prevPage[this.data.methodName](entity);
    }
    wx.navigateBack({ delta: 1 });
  },
  bindPickerChange() {
    let value = this.data.selected;
    // this.setData!({
    //   showPickerView: false,
    // });
    // this.triggerEvent('change', { value }, {});
    var pages = getCurrentPages();
    var prevPage = pages[pages.length - 2]; //上一个页面
    let entity = {};
    if (value) {
      entity = {
        id: value,
        name: this.data.filterList[this.data.selectedIndex].areaName,
      };
    } else {
      entity = { id: '', name: '' };
    }
    if (this.data.methodName && prevPage[this.data.methodName]) {
      prevPage[this.data.methodName](entity);
    }
    wx.navigateBack({ delta: 1 });
  },
});
