import { Userinfo, UserRole } from './store/user';

//app.ts
export interface IMyApp {
  resetUserinfo: () => void;
  getToken: () => string;
  globalData: {
    userInfo: Userinfo;
    token: string;
    userRoles: UserRole[];
  };
}

const initUserinfo = () => ({
  cellphone: '',
  comment: '',
  createAt: '',
  id: 0,
  isOpenOperLog: 0,
  isSetPassword: 0,
  lastLoginDate: '',
  loginAccount: '',
  loginCount: 0,
  name: '',
  operateId: 0,
  operateName: '',
  state: '',
  updateAt: '',
});
App<IMyApp>({
  onLaunch() {
    console.log('in onLaunch');
    try {
      let token = wx.getStorageSync('token');
      if (token) {
        this.globalData.token = token;
      }
    } catch (error) {}
  },
  globalData: {
    userInfo: initUserinfo(),
    token: '',
    userRoles: [],
  },
  getToken() {
    return this.globalData.token;
  },
  resetUserinfo() {
    this.globalData.token = '';
    this.globalData.userInfo = initUserinfo();
    this.globalData.userRoles = [];
    try {
      wx.setStorageSync('token', '');
    } catch (error) {}
  },
});
