"use strict";
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) if (e.indexOf(p[i]) < 0)
            t[p[i]] = s[p[i]];
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var constants_1 = require("../config/constants");
var app = getApp();
var fetch = function (req) {
    return new Promise(function (resolve, reject) {
        var token = app.globalData.token;
        wx.request(__assign({}, req, { header: token
                ? __assign({ token: token }, req.header) : req.header, success: resolve, fail: reject }));
    }).then(function (res) {
        var _a = res.data, code = _a.code, otherkeys = __rest(_a, ["code"]);
        if (code === constants_1.successCode) {
            console.log(res);
            if (res.header['Set-Cookie'])
                return {
                    header: res.header,
                    data: otherkeys,
                };
            return otherkeys;
        }
        else if (code === constants_1.logoutode) {
            app.resetUserinfo();
            wx.reLaunch({
                url: '/pages/index/index',
            });
            throw {
                errMsg: res.data.msg || '网络异常',
            };
        }
        else {
            throw {
                errMsg: res.data.msg || '网络异常',
            };
        }
    });
};
exports.systemFetch = function (req) {
    return fetch(__assign({}, req, { url: constants_1.masterUrl.SYSTEM_SERVER_URL + req.url }));
};
exports.statisticsFetch = function (req) {
    return fetch(__assign({}, req, { url: constants_1.masterUrl.STATISTICS_SERVER_URL + req.url }));
};
exports.customerFetch = function (req) {
    return fetch(__assign({}, req, { url: constants_1.masterUrl.CUSTOMER_SERVER_URL + req.url }));
};
exports.baseFetch = function (req) {
    return fetch(__assign({}, req, { url: constants_1.masterUrl.BASE_SERVER_URL + req.url }));
};
exports.default = fetch;
//# sourceMappingURL=data:application/json;base64,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