import { baseFetch, statisticsFetch } from '../../api/fetch';
import { formatTime } from '../../utils/util';
import { IMyApp } from '../../app';
const app = getApp<IMyApp>();

// miniprogram/pages/userGrowth/userGrowth.js
Page({
  onLoad() {
    this.initData();
    this.fetchAreaList();
  },
  /**
   * 页面的初始数据
   */
  data: {
    month: '',
    areaId: '',
    areaName: '',
    areaList: [],
    growthList: [],
    activateList: [],
    registerCount: 0,
    customerCount: 0,
    activeCount: 0,
    isAdmin: 0,
  },
  initData() {
    let time = formatTime(new Date());
    console.log(time);
    console.log(app.globalData.userRoles);
    this.setData!({
      userInfo: app.globalData.userInfo,
    });
    let isAdmin = 0;
    let registerRoute = app.globalData.userRoles.find(
      item => item.menuCode === '0083',
    );
    if (
      registerRoute &&
      registerRoute.listMenuButtonVo &&
      registerRoute.listMenuButtonVo.length
    ) {
      if (
        registerRoute.listMenuButtonVo.find(item => item.buttonCode === '0001')
      )
        isAdmin = 1;
    }

    this.setData!({ month: time.slice(0, 7), isAdmin }, () => {
      this.fetchList();
    });
  },
  fetchAreaList() {
    baseFetch({
      url: '/dcxy/baseArea/queryAll',
    })
      .then(res => {
        if (res.data) {
          this.setData!({
            areaList: res.data,
          });
        } else {
          this.setData!({
            areaList: [],
          });
        }
      })
      .catch(err => {
        console.log(err);
      });
  },
  fetchList(entity?: { areaId?: number; monthString?: string }) {
    if (this.data.areaId) {
      if (entity && entity.areaId) {
      } else entity = { ...entity, areaId: this.data.areaId };
    }
    this.fetchUserData(entity);
  },
  fetchUserData(entity) {
    let monthString =
      entity && entity.monthString ? entity.monthString : this.data.month;
    const [year, month] = monthString.split('-');
    let reqBody = {
      year,
      month,
      isAdmin: this.data.isAdmin,
      ...entity,
    };
    statisticsFetch({
      url: '/dcxy/reportInfo/boss/queryReportList',
      data: reqBody,
    })
      .then(res => {
        console.log(res);
        const { customerCount, dayVos, activeCount, dayAcs } = res.data;
        let dayList = new Array(31)
          .fill({
            count: 0,
          })
          .map((v, idx) => ({ ...v, days: idx + 1 }));

        if (dayVos && dayVos.length) {
          let oList = dayVos;
          for (let index = 0; index < oList.length; index++) {
            const element = oList[index];
            let daysIndex = Number(element.days.slice(-2));
            if (dayList[daysIndex - 1].count) {
              dayList[daysIndex - 1] = {
                ...dayList[daysIndex - 1],
                count: dayList[daysIndex - 1].count + element.count,
              };
            } else {
              dayList[daysIndex - 1] = {
                ...dayList[daysIndex - 1],
                count: element.count,
              };
            }
          }
        }
        let activateList = new Array(31)
          .fill({
            count: 0,
          })
          .map((v, idx) => ({ ...v, days: idx + 1 }));
        if (dayAcs && dayAcs.length) {
          let oList = dayAcs;
          for (let index = 0; index < oList.length; index++) {
            const element = oList[index];
            let daysIndex = Number(element.days.slice(-2));
            if (activateList[daysIndex - 1].count) {
              activateList[daysIndex - 1] = {
                ...activateList[daysIndex - 1],
                count: activateList[daysIndex - 1].count + element.count,
              };
            } else {
              activateList[daysIndex - 1] = {
                ...activateList[daysIndex - 1],
                count: element.count,
              };
            }
          }
        }

        let registerCount = dayVos.reduce(
          (total, current) => (total += current.count),
          0,
        );
        console.log('dayList:', dayList);
        this.setData!({
          growthList: dayList,
          activateList: activateList,
          registerCount: registerCount,
          customerCount: customerCount ? customerCount : 0,
          activeCount: activeCount ? activeCount : 0,
        });
      })
      .catch(err => {
        console.log(err);
      });
  },
  areaChangeHandle(val) {
    console.log('areaChangeHandle', val);
    const { id, name } = val;
    this.setData!(
      {
        areaId: id,
        areaName: name,
      },
      () => {
        if (id) {
          this.fetchList({ areaId: id });
        } else {
          this.fetchList();
        }
      },
    );
  },
  monthChangeHandle(val) {
    console.log('monthChangeHandle', val);
    const { value } = val.detail;
    this.fetchList({ monthString: value });
    this.setData!({
      month: value,
    });
  },
});
