//index.js
import { systemFetch } from '../../api/fetch';
const md5 = require('blueimp-md5');
//获取应用实例
import { IMyApp } from '../../app';
const app = getApp<IMyApp>();

Page({
  onLoad() {
    if (app.globalData.token) {
      this.tokenLoagin();
    }
  },
  data: {
    account: '',
    pwd: '',
    showPassword: false,
  },
  togglePassword() {
    this.setData!({
      showPassword: !this.data.showPassword,
    });
  },
  validateLoginData() {
    const { account, pwd } = this.data;
    if (!account) {
      wx.showToast({
        title: '请输入账户',
        icon: 'none',
      });
      return;
    }
    if (!pwd) {
      wx.showToast({
        title: '请输入密码',
        icon: 'none',
      });
      return;
    }
    return true;
  },
  tokenLoagin() {
    wx.showLoading({ title: '登陆中' });
    systemFetch({
      url: '/login/verifyCode',
    })
      .then((res: wx.RequestSuccessCallbackResult) => {
        console.log(res);
        return {
          code: res.data.verifyCode,
          cookie: res.header['Set-Cookie'],
        };
      })
      .then(({ cookie }: { code: string; cookie: string }) =>
        systemFetch({
          url: '/boss/login',
          method: 'POST',
          header: {
            cookie: cookie,
          },
          data: {
            token: app.globalData.token,
          },
        }),
      )
      .then(res => {
        console.log(res);
        const {
          data: { userInfo, userRoles },
        } = res;
        app.globalData.userInfo = userInfo;
        app.globalData.userRoles = userRoles;
        wx.hideLoading();
        wx.redirectTo({
          url: '/pages/homeAndReport/homeAndReport',
        });
      })
      .catch(err => {
        console.log(err);
        wx.hideLoading();
        wx.showToast({
          title: err.errMsg,
          icon: 'none',
        });
      });
  },
  loginHandle() {
    console.log(app.globalData);
    if (this.validateLoginData()) {
      const { account, pwd } = this.data;
      console.log(account, pwd);
      wx.showLoading({ title: '' });
      systemFetch({
        url: '/login/verifyCode',
      })
        .then((res: wx.RequestSuccessCallbackResult) => {
          console.log(res);
          return {
            code: res.data.verifyCode,
            cookie: res.header['Set-Cookie'],
          };
        })
        .then(({ code, cookie }: { code: string; cookie: string }) => {
          let mixpwd = md5(pwd);
          return systemFetch({
            url: '/boss/login',
            method: 'POST',
            header: {
              cookie: cookie,
            },
            data: {
              account,
              pwd: mixpwd,
              varifyCode: code,
            },
          });
        })
        .then(res => {
          console.log(res);
          const {
            token,
            data: { userInfo, userRoles },
          } = res;
          app.globalData.token = token;
          app.globalData.userInfo = userInfo;
          app.globalData.userRoles = userRoles;
          try {
            wx.setStorageSync('token', token);
          } catch (error) {}
          wx.hideLoading();
          wx.redirectTo({
            url: '/pages/homeAndReport/homeAndReport',
          });
        })
        .catch(err => {
          console.log(err);
          wx.hideLoading();
          wx.showToast({
            title: err.errMsg,
            icon: 'none',
          });
        });
    }
    // fetch()
    // wx.redirectTo({
    //   url: '/pages/home/home'
    // })
  },
  nameInputHandle(e) {
    const value = e.detail.value;
    this.updateInputValue('account', value);
  },
  passwardInoutHandle(e) {
    const value = e.detail.value;
    this.updateInputValue('pwd', value);
  },
  updateInputValue(key: string, value: string) {
    this.setData!({
      [key]: value,
    });
  },
});
