"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var fetch_1 = require("../../api/fetch");
var md5 = require('blueimp-md5');
var app = getApp();
Page({
    onLoad: function () {
        if (app.globalData.token) {
            this.tokenLoagin();
        }
    },
    data: {
        account: '',
        pwd: '',
        showPassword: false,
    },
    togglePassword: function () {
        this.setData({
            showPassword: !this.data.showPassword,
        });
    },
    validateLoginData: function () {
        var _a = this.data, account = _a.account, pwd = _a.pwd;
        if (!account) {
            wx.showToast({
                title: '请输入账户',
                icon: 'none',
            });
            return;
        }
        if (!pwd) {
            wx.showToast({
                title: '请输入密码',
                icon: 'none',
            });
            return;
        }
        return true;
    },
    tokenLoagin: function () {
        wx.showLoading({ title: '登陆中' });
        fetch_1.systemFetch({
            url: '/login/verifyCode',
        })
            .then(function (res) {
            console.log(res);
            return {
                code: res.data.verifyCode,
                cookie: res.header['Set-Cookie'],
            };
        })
            .then(function (_a) {
            var cookie = _a.cookie;
            return fetch_1.systemFetch({
                url: '/boss/login',
                method: 'POST',
                header: {
                    cookie: cookie,
                },
                data: {
                    token: app.globalData.token,
                },
            });
        })
            .then(function (res) {
            console.log(res);
            var _a = res.data, userInfo = _a.userInfo, userRoles = _a.userRoles;
            app.globalData.userInfo = userInfo;
            app.globalData.userRoles = userRoles;
            wx.hideLoading();
            wx.redirectTo({
                url: '/pages/homeAndReport/homeAndReport',
            });
        })
            .catch(function (err) {
            console.log(err);
            wx.hideLoading();
            wx.showToast({
                title: err.errMsg,
                icon: 'none',
            });
        });
    },
    loginHandle: function () {
        console.log(app.globalData);
        if (this.validateLoginData()) {
            var _a = this.data, account_1 = _a.account, pwd_1 = _a.pwd;
            console.log(account_1, pwd_1);
            wx.showLoading({ title: '' });
            fetch_1.systemFetch({
                url: '/login/verifyCode',
            })
                .then(function (res) {
                console.log(res);
                return {
                    code: res.data.verifyCode,
                    cookie: res.header['Set-Cookie'],
                };
            })
                .then(function (_a) {
                var code = _a.code, cookie = _a.cookie;
                var mixpwd = md5(pwd_1);
                return fetch_1.systemFetch({
                    url: '/boss/login',
                    method: 'POST',
                    header: {
                        cookie: cookie,
                    },
                    data: {
                        account: account_1,
                        pwd: mixpwd,
                        varifyCode: code,
                    },
                });
            })
                .then(function (res) {
                console.log(res);
                var token = res.token, _a = res.data, userInfo = _a.userInfo, userRoles = _a.userRoles;
                app.globalData.token = token;
                app.globalData.userInfo = userInfo;
                app.globalData.userRoles = userRoles;
                try {
                    wx.setStorageSync('token', token);
                }
                catch (error) { }
                wx.hideLoading();
                wx.redirectTo({
                    url: '/pages/homeAndReport/homeAndReport',
                });
            })
                .catch(function (err) {
                console.log(err);
                wx.hideLoading();
                wx.showToast({
                    title: err.errMsg,
                    icon: 'none',
                });
            });
        }
    },
    nameInputHandle: function (e) {
        var value = e.detail.value;
        this.updateInputValue('account', value);
    },
    passwardInoutHandle: function (e) {
        var value = e.detail.value;
        this.updateInputValue('pwd', value);
    },
    updateInputValue: function (key, value) {
        this.setData((_a = {},
            _a[key] = value,
            _a));
        var _a;
    },
});
//# sourceMappingURL=data:application/json;base64,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