import { statisticsFetch } from '../../api/fetch';
import { formatTime } from '../../utils/util';

// miniprogram/pages/home/home.js
Component({
  lifetimes: {
    attached() {
      console.log('in show ', this.data.fetched);
      !this.data.fetched && this.fetchRechargeData();
    },
  },
  /**
   * 页面的初始数据
   */
  data: {
    timeType: 0,
    fetched: false,
    serviceList: [],
    rechargeData: {
      title: '充值总额',
      numberType: 'price',
      count: 0,
    },
    rechargeCount: {
      title: '充值总笔数',
      numberType: '',
      count: 0,
    },
    onlineRechargeData: {
      title: '线上充值',
      numberType: '1',
      count: 0,
      price: 0,
    },
    offlineRechargeData: {
      title: '线下充值',
      numberType: '1',
      count: 0,
      price: 0,
    },
    comsumerData: {
      title: '消费总额',
      numberType: 'price',
      count: 0,
    },
    comsumerCount: {
      title: '消费总笔数',
      numberType: '',
      count: 0,
    },
    refundData: {
      title: '退款总额',
      numberType: 'price',
      count: 0,
    },
    refundCount: {
      title: '退款总笔数',
      numberType: '',
      count: 0,
    },
    testData: {
      title: '充值总额',
      numberType: 'price',
      count: 0,
    },
    testData2: {
      title: '线上充值',
      numberType: '1',
      count: 0,
      price: 0,
    },
  },
  methods: {
    changeTimeType(e) {
      const { timetype } = e.currentTarget.dataset;
      if (timetype === this.data.timeType) return;
      this.setData({
        timeType: timetype,
      });
      this.fetchRechargeData(timetype);
      return false;
    },
    fetchRechargeData(timeType?: number) {
      if (!timeType) timeType = this.data.timeType;
      const today = formatTime(new Date());
      let date = today.split(' ')[0];
      let entity = {
        timeType,
      };
      if (timeType === 0) {
        entity.date = date;
      } else if (timeType === 1) {
        entity.month = date.slice(0, 7);
      } else if (timeType === 2) {
        entity.year = date.slice(0, 4);
      }
      wx.showLoading({ title: '', mask: true });

      let rechargeDataFetch = statisticsFetch({
        url: '/dcxy/reportInfo/queryRechargeOrderListV2',
        method: 'POST',
        data: entity,
      }).then(res => {
        const data = res.rechargeOrderCountVo;
        if (data) {
          const {
            rechargeMen,
            rechargeMoney,
            refundCount,
            refundMoney,
            offlineRechargeMen,
            offlineRechargeMoney,
            onlineRechargeMen,
            onlineRechargeMoney,
          } = data;
          this.setData({
            'rechargeData.count': rechargeMoney,
            'rechargeCount.count': rechargeMen,
            'refundData.count': refundMoney,
            'refundCount.count': refundCount,
            'onlineRechargeData.price': onlineRechargeMoney,
            'onlineRechargeData.count': onlineRechargeMen,
            'offlineRechargeData.price': offlineRechargeMoney,
            'offlineRechargeData.count': offlineRechargeMen,
          });
        } else {
          this.setData({
            'rechargeData.count': 0,
            'rechargeCount.count': 0,
            'refundData.count': 0,
            'refundCount.count': 0,
            'onlineRechargeData.price': 0,
            'onlineRechargeData.count': 0,
            'offlineRechargeData.price': 0,
            'offlineRechargeData.count': 0,
          });
        }
      });
      let consumeDataFetch = statisticsFetch({
        url: '/dcxy/reportInfo/queryConsumeOrderList',
        method: 'POST',
        data: entity,
      }).then(res => {
        const { consumeCountVo, data } = res;
        console.log(res);
        this.setData({
          serviceList: data.map(item => ({
            serviceId: item.serviceId,
            title: item.serviceName,
            numberType: '1',
            count: item.payMen,
            price: item.payableMoney,
          })),
          'comsumerData.count':
            consumeCountVo && consumeCountVo.payableMoney
              ? consumeCountVo.payableMoney
              : 0,
          'comsumerCount.count':
            consumeCountVo && consumeCountVo.payMen ? consumeCountVo.payMen : 0,
        });
      });
      Promise.all([consumeDataFetch, rechargeDataFetch])
        .then(() => {
          wx.hideLoading();
        })
        .catch((err: wx.GeneralCallbackResult) => {
          wx.hideLoading();
          wx.showToast({
            title: err.errMsg,
            icon: 'none',
          });
          console.log(err);
        });
    },
  },
});
