import { statisticsFetch, baseFetch } from '../../api/fetch';

// miniprogram/pages/feedback/feedback.js
Page({
  onLoad() {
    this.initData();
    this.fetchAreaList();
  },
  /**
   * 页面的初始数据
   */
  data: {
    tabIndex: 1,
    areaId: '',
    list1: [],
    list2: [],
    areaList: [],
    list: [],
    pageNum: [null, 0, 0],
  },
  initData() {
    this.fetchList(1);
    this.fetchList(2);
  },
  toggleList(e) {
    const { tabindex } = e.currentTarget.dataset;
    if (tabindex !== this.data.tabIndex) {
      this.setData!({ tabIndex: tabindex }, () => {
        this.fetchList(tabindex);
      });
    }
  },
  fetchList(state?: number) {
    if (!state) state = this.data.tabIndex;
    wx.showLoading({ title: '' });
    statisticsFetch({
      url: '/dcxy/reportInfo/queryFeedbackListV2',
      data: this.data.areaId
        ? {
            state,
            areaId: this.data.areaId,
          }
        : { state },
    })
      .then(res => {
        wx.hideLoading();
        const list = res.data;
        let viewList = list.slice(0, 10);
        if (state === this.data.tabIndex) {
          this.setData!({
            list: viewList,
          });
        }
        this.setData!({
          ['list' + state]: list,
          [`pageNum[${state}]`]: 0,
        });
      })
      .catch(err => {
        console.log(err);
        wx.showToast({
          title: err.errMsg,
          icon: 'none',
        });
      });
  },
  bindPickerChange(e) {
    console.log(e);
    const { value } = e.detail;
    this.setData!(
      {
        areaId: value,
      },
      () => {
        this.initData();
      },
    );
  },
  refreshHandle(e) {
    this.fetchList();
  },
  fetchAreaList() {
    baseFetch({
      url: '/dcxy/baseArea/queryAll',
    })
      .then(res => {
        if (res.data) {
          this.setData!({
            areaList: res.data,
          });
        } else {
          this.setData!({
            areaList: [],
          });
        }
      })
      .catch(err => {
        console.log(err);
      });
  },
  getMoreListItem() {
    let state = this.data.tabIndex;
    let index = this.data.pageNum[state] + 1;
    let max = Math.ceil(this.data['list' + state].length / 10);
    console.log('in getMoreListItem', index, max);
    if (index >= max) {
      wx.showToast({
        title: '没有更多数据',
        icon: 'none',
      });
    } else {
      this.setData({
        [`pageNum[${state}]`]: index,
        list: [
          ...this.data.list,
          ...this.data['list' + state].slice(index * 10, (index + 1) * 10),
        ],
      });
    }
  },
});
