"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var fetch_1 = require("../../api/fetch");
Page({
    onLoad: function () {
        this.initData();
        this.fetchAreaList();
    },
    data: {
        tabIndex: 1,
        areaId: '',
        list1: [],
        list2: [],
        areaList: [],
        list: [],
        pageNum: [null, 0, 0],
    },
    initData: function () {
        this.fetchList(1);
        this.fetchList(2);
    },
    toggleList: function (e) {
        var _this = this;
        var tabindex = e.currentTarget.dataset.tabindex;
        if (tabindex !== this.data.tabIndex) {
            this.setData({ tabIndex: tabindex }, function () {
                _this.fetchList(tabindex);
            });
        }
    },
    fetchList: function (state) {
        var _this = this;
        if (!state)
            state = this.data.tabIndex;
        wx.showLoading({ title: '' });
        fetch_1.statisticsFetch({
            url: '/dcxy/reportInfo/queryFeedbackListV2',
            data: this.data.areaId
                ? {
                    state: state,
                    areaId: this.data.areaId,
                }
                : { state: state },
        })
            .then(function (res) {
            wx.hideLoading();
            var list = res.data;
            var viewList = list.slice(0, 10);
            if (state === _this.data.tabIndex) {
                _this.setData({
                    list: viewList,
                });
            }
            _this.setData((_a = {},
                _a['list' + state] = list,
                _a["pageNum[" + state + "]"] = 0,
                _a));
            var _a;
        })
            .catch(function (err) {
            console.log(err);
            wx.showToast({
                title: err.errMsg,
                icon: 'none',
            });
        });
    },
    bindPickerChange: function (e) {
        var _this = this;
        console.log(e);
        var value = e.detail.value;
        this.setData({
            areaId: value,
        }, function () {
            _this.initData();
        });
    },
    refreshHandle: function (e) {
        this.fetchList();
    },
    fetchAreaList: function () {
        var _this = this;
        fetch_1.baseFetch({
            url: '/dcxy/baseArea/queryAll',
        })
            .then(function (res) {
            if (res.data) {
                _this.setData({
                    areaList: res.data,
                });
            }
            else {
                _this.setData({
                    areaList: [],
                });
            }
        })
            .catch(function (err) {
            console.log(err);
        });
    },
    getMoreListItem: function () {
        var state = this.data.tabIndex;
        var index = this.data.pageNum[state] + 1;
        var max = Math.ceil(this.data['list' + state].length / 10);
        console.log('in getMoreListItem', index, max);
        if (index >= max) {
            wx.showToast({
                title: '没有更多数据',
                icon: 'none',
            });
        }
        else {
            this.setData((_a = {},
                _a["pageNum[" + state + "]"] = index,
                _a.list = this.data.list.concat(this.data['list' + state].slice(index * 10, (index + 1) * 10)),
                _a));
        }
        var _a;
    },
});
//# sourceMappingURL=data:application/json;base64,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