"use strict";
var userActivityChart = null;
var month = '';
function initChart(canvas, width, height, F2) {
    var data = [];
    userActivityChart = new F2.Chart({
        el: canvas,
        width: width,
        height: height,
    });
    userActivityChart.source(data, {
        days: {
            min: 1,
            max: 31,
        },
    });
    userActivityChart.tooltip({
        showItemMarker: false,
        background: {
            radius: 2,
            fill: '#6895fe',
            padding: [6, 10],
        },
        onShow: function (ev) {
            var items = ev.items;
            items[0].name = '';
            items[0].value = month + '-' + items[0].title;
            items[1].name = '';
            items[1].value = items[1].value + '人';
        },
    });
    userActivityChart
        .line()
        .position('days*count')
        .color('#6895fe')
        .shape('smooth')
        .size(4);
    userActivityChart
        .area()
        .position('days*count')
        .color('l(90) 0:#6895fe 1:#fff')
        .shape('smooth')
        .style({
        fillOpacity: 0.6,
    });
    userActivityChart.render();
    return userActivityChart;
}
Component({
    properties: {
        dataList: {
            type: Array,
            value: [],
            observer: function (newVal) {
                userActivityChart && userActivityChart.changeData(newVal);
            },
        },
        month: {
            type: String,
            value: '',
            observer: function (newVal) {
                month = newVal;
            },
        },
    },
    data: {
        opts: {
            onInit: initChart,
        },
    },
});
//# sourceMappingURL=data:application/json;base64,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