import { formatPrice } from '../../../utils/util';

// pages/components/ServiceTypeChart/ServiceTypeChart.js
Component({
  /**
   * 组件的属性列表
   */
  properties: {
    dataList: {
      type: Array,
      value: [],
      observer(newVal) {
        let maxnum = Math.ceil(
          Math.max(...newVal.map(item => item.payableMoney)) / 0.9,
        );
        let list = newVal.map(item => ({
          ...item,
          payableMoney: formatPrice(item.payableMoney),
          precent: Math.ceil((item.payableMoney / maxnum) * 100),
        }));
        this.setData({
          list,
        });
      },
    },
  },

  /**
   * 组件的初始数据
   */
  data: {
    list: [],
  },

  /**
   * 组件的方法列表
   */
  methods: {},
});
