"use strict";
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
Object.defineProperty(exports, "__esModule", { value: true });
var util_1 = require("../../../utils/util");
Component({
    properties: {
        dataList: {
            type: Array,
            value: [],
            observer: function (newVal) {
                var maxnum = Math.ceil(Math.max.apply(Math, newVal.map(function (item) { return item.payableMoney; })) / 0.9);
                var list = newVal.map(function (item) { return (__assign({}, item, { payableMoney: util_1.formatPrice(item.payableMoney), precent: Math.ceil((item.payableMoney / maxnum) * 100) })); });
                this.setData({
                    list: list,
                });
            },
        },
    },
    data: {
        list: [],
    },
    methods: {},
});
//# sourceMappingURL=data:application/json;base64,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