Component({
  properties: {
    placeholder: {
      type: String,
      value: '请选择',
    },
    range: {
      type: Array,
      value: [],
    },
    rangeKey: {
      type: String,
      value: 'key',
    },
    mode: {
      type: String,
      value: 'selector',
    },
    fields: {
      type: String,
      value: 'day',
    },
    value: {
      type: String,
      value: '',
      observer(newVal) {
        console.log('in select ob', newVal);
        this.setData({ selected: newVal });
      },
    },
  },
  data: {
    selected: '',
  },
  methods: {
    bindPickerChange(e) {
      const { value } = e.detail;
      console.log(value);
      this.setData!({
        selected: value,
      });
      this.triggerEvent('change', { value });
    },
  },
});
