// pages/components/RefundChart/RefundChart.js
let refundChart = null;
let month = '';

function initChart(canvas, width, height, F2) {
  const data = [];
  refundChart = new F2.Chart({
    el: canvas,
    width,
    height,
  });

  refundChart.source(data, {
    days: {
      min: 1,
      max: 31,
    },
  });
  refundChart.tooltip({
    showItemMarker: false,
    background: {
      radius: 2,
      fill: '#f166fd',
      padding: [6, 10],
    },
    onShow(ev) {
      const { items } = ev;
      items[0].name = '';
      items[0].value = month + '-' + items[0].title;
      items[1].name = '';
      items[1].value = items[1].value + '元';
    },
  });
  refundChart
    .line()
    .position('days*refundMoney')
    .color('#f166fd')
    .shape('smooth')
    .size(4);
  refundChart
    .area()
    .position('days*refundMoney')
    .color('l(90) 0:#f166fd 1:#fff')
    .shape('smooth')
    .style({
      fillOpacity: 0.6,
    });
  // refundChart.axis('refundMoney', false);
  refundChart.render();
  return refundChart;
}

Component({
  properties: {
    dataList: {
      type: Array,
      value: [],
      observer(newVal) {
        let list = newVal.map(item => ({
          ...item,
          refundMoney: Math.abs(item.refundMoney),
        }));
        refundChart && refundChart.changeData(list);
      },
    },
    month: {
      type: String,
      value: '',
      observer(newVal) {
        month = newVal;
      },
    },
  },
  data: {
    opts: {
      onInit: initChart,
    },
  },
});
