"use strict";
var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
var refundChart = null;
var month = '';
function initChart(canvas, width, height, F2) {
    var data = [];
    refundChart = new F2.Chart({
        el: canvas,
        width: width,
        height: height,
    });
    refundChart.source(data, {
        days: {
            min: 1,
            max: 31,
        },
    });
    refundChart.tooltip({
        showItemMarker: false,
        background: {
            radius: 2,
            fill: '#f166fd',
            padding: [6, 10],
        },
        onShow: function (ev) {
            var items = ev.items;
            items[0].name = '';
            items[0].value = month + '-' + items[0].title;
            items[1].name = '';
            items[1].value = items[1].value + '元';
        },
    });
    refundChart
        .line()
        .position('days*refundMoney')
        .color('#f166fd')
        .shape('smooth')
        .size(4);
    refundChart
        .area()
        .position('days*refundMoney')
        .color('l(90) 0:#f166fd 1:#fff')
        .shape('smooth')
        .style({
        fillOpacity: 0.6,
    });
    refundChart.render();
    return refundChart;
}
Component({
    properties: {
        dataList: {
            type: Array,
            value: [],
            observer: function (newVal) {
                var list = newVal.map(function (item) { return (__assign({}, item, { refundMoney: Math.abs(item.refundMoney) })); });
                refundChart && refundChart.changeData(list);
            },
        },
        month: {
            type: String,
            value: '',
            observer: function (newVal) {
                month = newVal;
            },
        },
    },
    data: {
        opts: {
            onInit: initChart,
        },
    },
});
//# sourceMappingURL=data:application/json;base64,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