let rechargeChart = null;
let month = '';

function initChart(canvas, width, height, F2) {
  const data = [];
  rechargeChart = new F2.Chart({
    el: canvas,
    width,
    height,
  });

  rechargeChart.source(data, {
    days: {
      min: 1,
      max: 31,
    },
  });
  rechargeChart.tooltip({
    showItemMarker: false,
    background: {
      radius: 2,
      fill: '#6895fe',
      padding: [6, 10],
    },
    onShow(ev) {
      const { items } = ev;
      items[0].name = '';
      items[0].value = month + '-' + items[0].title;
      items[1].name = '';
      items[1].value = items[1].value + '元';
    },
  });
  rechargeChart
    .line()
    .position('days*rechargeMoney')
    .color('#6895fe')
    .shape('smooth')
    .size(4);
  rechargeChart
    .area()
    .position('days*rechargeMoney')
    .color('l(90) 0:#6895fe 1:#fff')
    .shape('smooth')
    .style({
      fillOpacity: 0.6,
    });
  // rechargeChart.axis('rechargeMoney', false);
  rechargeChart.render();
  return rechargeChart;
}

Component({
  properties: {
    dataList: {
      type: Array,
      value: [],
      observer(newVal) {
        rechargeChart && rechargeChart.changeData(newVal);
      },
    },
    month: {
      type: String,
      value: '',
      observer(newVal) {
        month = newVal;
      },
    },
  },
  data: {
    opts: {
      onInit: initChart,
    },
  },
});
