"use strict";
var rechargeChart = null;
var month = '';
function initChart(canvas, width, height, F2) {
    var data = [];
    rechargeChart = new F2.Chart({
        el: canvas,
        width: width,
        height: height,
    });
    rechargeChart.source(data, {
        days: {
            min: 1,
            max: 31,
        },
    });
    rechargeChart.tooltip({
        showItemMarker: false,
        background: {
            radius: 2,
            fill: '#6895fe',
            padding: [6, 10],
        },
        onShow: function (ev) {
            var items = ev.items;
            items[0].name = '';
            items[0].value = month + '-' + items[0].title;
            items[1].name = '';
            items[1].value = items[1].value + '元';
        },
    });
    rechargeChart
        .line()
        .position('days*rechargeMoney')
        .color('#6895fe')
        .shape('smooth')
        .size(4);
    rechargeChart
        .area()
        .position('days*rechargeMoney')
        .color('l(90) 0:#6895fe 1:#fff')
        .shape('smooth')
        .style({
        fillOpacity: 0.6,
    });
    rechargeChart.render();
    return rechargeChart;
}
Component({
    properties: {
        dataList: {
            type: Array,
            value: [],
            observer: function (newVal) {
                rechargeChart && rechargeChart.changeData(newVal);
            },
        },
        month: {
            type: String,
            value: '',
            observer: function (newVal) {
                month = newVal;
            },
        },
    },
    data: {
        opts: {
            onInit: initChart,
        },
    },
});
//# sourceMappingURL=data:application/json;base64,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