import { formatPrice } from '../../../utils/util';

// components/PriceAndCount/PriceAndCount.js
Component({
  /**
   * 组件的属性列表
   */
  properties: {
    tagData: {
      type: Object,
      value: {
        title: '',
        numberType: '',
        count: 0,
      },
      observer: function(newVal) {
        const { count, numberType } = newVal;
        let formatCount = count.toString();
        if (numberType === 'price') {
          formatCount = formatPrice(count);
        }
        this.setData({
          formatCount,
        });
      },
    },
  },
  /**
   * 组件的初始数据
   */
  data: {
    formatCount: '0',
  },

  /**
   * 组件的方法列表
   */
  methods: {},
});
