"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var util_1 = require("../../../utils/util");
Component({
    properties: {
        tagData: {
            type: Object,
            value: {
                title: '',
                numberType: '',
                count: 0,
            },
            observer: function (newVal) {
                var count = newVal.count, numberType = newVal.numberType;
                var formatCount = count.toString();
                if (numberType === 'price') {
                    formatCount = util_1.formatPrice(count);
                }
                this.setData({
                    formatCount: formatCount,
                });
            },
        },
    },
    data: {
        formatCount: '0',
    },
    methods: {},
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiUHJpY2VBbmRDb3VudC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIlByaWNlQW5kQ291bnQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSw0Q0FBa0Q7QUFHbEQsU0FBUyxDQUFDO0lBSVIsVUFBVSxFQUFFO1FBQ1YsT0FBTyxFQUFFO1lBQ1AsSUFBSSxFQUFFLE1BQU07WUFDWixLQUFLLEVBQUU7Z0JBQ0wsS0FBSyxFQUFFLEVBQUU7Z0JBQ1QsVUFBVSxFQUFFLEVBQUU7Z0JBQ2QsS0FBSyxFQUFFLENBQUM7YUFDVDtZQUNELFFBQVEsRUFBRSxVQUFTLE1BQU07Z0JBQ2YsSUFBQSxvQkFBSyxFQUFFLDhCQUFVLENBQVk7Z0JBQ3JDLElBQUksV0FBVyxHQUFHLEtBQUssQ0FBQyxRQUFRLEVBQUUsQ0FBQztnQkFDbkMsRUFBRSxDQUFDLENBQUMsVUFBVSxLQUFLLE9BQU8sQ0FBQyxDQUFDLENBQUM7b0JBQzNCLFdBQVcsR0FBRyxrQkFBVyxDQUFDLEtBQUssQ0FBQyxDQUFDO2dCQUNuQyxDQUFDO2dCQUNELElBQUksQ0FBQyxPQUFPLENBQUM7b0JBQ1gsV0FBVyxhQUFBO2lCQUNaLENBQUMsQ0FBQztZQUNMLENBQUM7U0FDRjtLQUNGO0lBSUQsSUFBSSxFQUFFO1FBQ0osV0FBVyxFQUFFLEdBQUc7S0FDakI7SUFLRCxPQUFPLEVBQUUsRUFBRTtDQUNaLENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IGZvcm1hdFByaWNlIH0gZnJvbSAnLi4vLi4vLi4vdXRpbHMvdXRpbCc7XG5cbi8vIGNvbXBvbmVudHMvUHJpY2VBbmRDb3VudC9QcmljZUFuZENvdW50LmpzXG5Db21wb25lbnQoe1xuICAvKipcbiAgICog57uE5Lu255qE5bGe5oCn5YiX6KGoXG4gICAqL1xuICBwcm9wZXJ0aWVzOiB7XG4gICAgdGFnRGF0YToge1xuICAgICAgdHlwZTogT2JqZWN0LFxuICAgICAgdmFsdWU6IHtcbiAgICAgICAgdGl0bGU6ICcnLFxuICAgICAgICBudW1iZXJUeXBlOiAnJyxcbiAgICAgICAgY291bnQ6IDAsXG4gICAgICB9LFxuICAgICAgb2JzZXJ2ZXI6IGZ1bmN0aW9uKG5ld1ZhbCkge1xuICAgICAgICBjb25zdCB7IGNvdW50LCBudW1iZXJUeXBlIH0gPSBuZXdWYWw7XG4gICAgICAgIGxldCBmb3JtYXRDb3VudCA9IGNvdW50LnRvU3RyaW5nKCk7XG4gICAgICAgIGlmIChudW1iZXJUeXBlID09PSAncHJpY2UnKSB7XG4gICAgICAgICAgZm9ybWF0Q291bnQgPSBmb3JtYXRQcmljZShjb3VudCk7XG4gICAgICAgIH1cbiAgICAgICAgdGhpcy5zZXREYXRhKHtcbiAgICAgICAgICBmb3JtYXRDb3VudCxcbiAgICAgICAgfSk7XG4gICAgICB9LFxuICAgIH0sXG4gIH0sXG4gIC8qKlxuICAgKiDnu4Tku7bnmoTliJ3lp4vmlbDmja5cbiAgICovXG4gIGRhdGE6IHtcbiAgICBmb3JtYXRDb3VudDogJzAnLFxuICB9LFxuXG4gIC8qKlxuICAgKiDnu4Tku7bnmoTmlrnms5XliJfooahcbiAgICovXG4gIG1ldGhvZHM6IHt9LFxufSk7XG4iXX0=