import { formatPrice } from '../../../utils/util';

// pages/components/PayTypeChart/PayTypeChart.js
let paytypeChart = null;
let month = '';
const colorMap = {
  aimi: '#EB7E59',
  bean: '#13C2C2',
  discount: '#FACC14',
  online: '#1890FF',
};

function initChart(canvas, width, height, F2) {
  const data = [];
  paytypeChart = new F2.Chart({
    el: canvas,
    width,
    height,
    padding: ['auto', 'auto', 50, 'auto'],
  });

  paytypeChart.source(data, {
    days: {
      min: 1,
      max: 31,
    },
  });
  paytypeChart.tooltip({
    showItemMarker: false,
    background: {
      radius: 2,
      fill: '#f166fd',
      padding: [6, 10],
    },
    onShow(ev) {
      console.log(ev);
      const { items } = ev;
      items[0].name = items[0].title;
      items[0].value = formatPrice(Number(items[0].value));
      // items[1].name = '';
      // items[1].value = items[1].value + '元';
    },
  });

  // paytypeChart.coord('polar', {
  //   transposed: true,
  //   innerRadius: 0.5,
  //   radius: 0.9,
  // });
  paytypeChart.legend({
    position: 'right',
    marker: 'square',
  });
  paytypeChart
    .interval()
    .position('name*count')
    .color('name', ['#EB7E59', '#13C2C2', '#FACC14', '#1890FF']);
  paytypeChart.axis('name', {
    label: {
      rotate: -Math.PI / 4,
      textAlign: 'end',
      textBaseline: 'middle',
    },
  });
  paytypeChart.render();

  // 绘制内阴影
  // const frontPlot = paytypeChart.get('frontPlot');
  // const coord = paytypeChart.get('coord'); // 获取坐标系对象
  // frontPlot.addShape('sector', {
  //   attrs: {
  //     x: coord.circleRadius,
  //     y: coord.center.y,
  //     r: coord.circleRadius * coord.innerRadius * 1.1, // 全半径
  //     r0: 0,
  //     fill: '#000',
  //   },
  // });
  // paytypeChart.get('canvas').draw();
  // console.log('coord', coord);

  return paytypeChart;
}

Component({
  properties: {
    dataList: {
      type: Array,
      value: [],
      observer(newVal) {
        paytypeChart &&
          paytypeChart.legend({
            position: 'right',
            marker: 'square',
            // custom: true,
            itemFormatter: val => {
              let item = newVal.find(item => item.name === val);
              if (item) {
                let name = item.name;
                while (name.length < 4) {
                  name += '\xa0';
                }
                name = name.replace(/\xa0/g, '\xa0\xa0\xa0');
                console.log(name, name.length);
                return name + '   ' + formatPrice(item.count);
              } else {
                return '';
              }
            },
            onClick: ev => {
              console.log(ev, paytypeChart);
              // let point = paytypeChart.getXY(clickedItem);
              // paytypeChart.showTooltip(point);
            },
          });
        paytypeChart && paytypeChart.changeData(newVal);
      },
    },
    month: {
      type: String,
      value: '',
      observer(newVal) {
        month = newVal;
      },
    },
  },
  data: {
    opts: {
      onInit: initChart,
    },
  },
});
