"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var util_1 = require("../../../utils/util");
var paytypeChart = null;
var month = '';
var colorMap = {
    aimi: '#EB7E59',
    bean: '#13C2C2',
    discount: '#FACC14',
    online: '#1890FF',
};
function initChart(canvas, width, height, F2) {
    var data = [];
    paytypeChart = new F2.Chart({
        el: canvas,
        width: width,
        height: height,
        padding: ['auto', 'auto', 50, 'auto'],
    });
    paytypeChart.source(data, {
        days: {
            min: 1,
            max: 31,
        },
    });
    paytypeChart.tooltip({
        showItemMarker: false,
        background: {
            radius: 2,
            fill: '#f166fd',
            padding: [6, 10],
        },
        onShow: function (ev) {
            console.log(ev);
            var items = ev.items;
            items[0].name = items[0].title;
            items[0].value = util_1.formatPrice(Number(items[0].value));
        },
    });
    paytypeChart.legend({
        position: 'right',
        marker: 'square',
    });
    paytypeChart
        .interval()
        .position('name*count')
        .color('name', ['#EB7E59', '#13C2C2', '#FACC14', '#1890FF']);
    paytypeChart.axis('name', {
        label: {
            rotate: -Math.PI / 4,
            textAlign: 'end',
            textBaseline: 'middle',
        },
    });
    paytypeChart.render();
    return paytypeChart;
}
Component({
    properties: {
        dataList: {
            type: Array,
            value: [],
            observer: function (newVal) {
                paytypeChart &&
                    paytypeChart.legend({
                        position: 'right',
                        marker: 'square',
                        itemFormatter: function (val) {
                            var item = newVal.find(function (item) { return item.name === val; });
                            if (item) {
                                var name_1 = item.name;
                                while (name_1.length < 4) {
                                    name_1 += '\xa0';
                                }
                                name_1 = name_1.replace(/\xa0/g, '\xa0\xa0\xa0');
                                console.log(name_1, name_1.length);
                                return name_1 + '   ' + util_1.formatPrice(item.count);
                            }
                            else {
                                return '';
                            }
                        },
                        onClick: function (ev) {
                            console.log(ev, paytypeChart);
                        },
                    });
                paytypeChart && paytypeChart.changeData(newVal);
            },
        },
        month: {
            type: String,
            value: '',
            observer: function (newVal) {
                month = newVal;
            },
        },
    },
    data: {
        opts: {
            onInit: initChart,
        },
    },
});
//# sourceMappingURL=data:application/json;base64,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