import { IMyApp } from '../../../app';

// pages/components/NavItem/NavItem.js

const app = getApp<IMyApp>();
Component({
  /**
   * 组件的属性列表
   */
  properties: {
    navData: {
      type: Object,
      value: {
        name: '',
        icon: '',
        url: '',
        reLaunch: false,
      },
    },
  },

  /**
   * 组件的初始数据
   */
  data: {},

  /**
   * 组件的方法列表
   */
  methods: {
    clickHandle() {
      if (this.data.navData.reLaunch && this.data.navData.name === '退出登录') {
        app.resetUserinfo();
        wx.redirectTo({
          url: this.data.navData.url,
        });
      } else {
        wx.navigateTo({
          url: this.data.navData.url,
        });
      }
    },
  },
});
