// pages/components/ConsumeCountChart/ConsumeCountChart.js
let consumeCountChart = null;
let month = '';

function initChart(canvas, width, height, F2) {
  const data = [];
  consumeCountChart = new F2.Chart({
    el: canvas,
    width,
    height,
  });

  consumeCountChart.source(data, {
    days: {
      min: 1,
      max: 31,
    },
  });
  consumeCountChart.tooltip({
    showItemMarker: false,
    background: {
      radius: 2,
      fill: '#68d0fe',
      padding: [6, 10],
    },
    onShow(ev) {
      const { items } = ev;
      items[0].name = '';
      items[0].value = month + '-' + items[0].title;
      items[1].name = '';
      items[1].value = items[1].value + '笔';
    },
  });
  consumeCountChart
    .line()
    .position('days*payMen')
    .color('#68d0fe')
    .shape('smooth')
    .size(4);
  consumeCountChart
    .area()
    .position('days*payMen')
    .color('l(90) 0:#68d0fe 1:#fff')
    .shape('smooth')
    .style({
      fillOpacity: 0.6,
    });
  // consumeCountChart.axis('payMen', false);
  consumeCountChart.render();
  return consumeCountChart;
}

Component({
  properties: {
    dataList: {
      type: Array,
      value: [],
      observer(newVal) {
        consumeCountChart && consumeCountChart.changeData(newVal);
      },
    },
    month: {
      type: String,
      value: '',
      observer(newVal) {
        month = newVal;
      },
    },
  },
  data: {
    opts: {
      onInit: initChart,
    },
  },
});
