let consumeChart = null;
let month = '';

function initChart(canvas, width, height, F2) {
  const data = [];
  consumeChart = new F2.Chart({
    el: canvas,
    width,
    height,
  });

  consumeChart.source(data, {
    days: {
      min: 1,
      max: 31,
    },
  });
  consumeChart.tooltip({
    showItemMarker: false,
    background: {
      radius: 2,
      fill: '#6edb8f',
      padding: [6, 10],
    },
    onShow(ev) {
      const { items } = ev;
      items[0].name = '';
      items[0].value = month + '-' + items[0].title;
      items[1].name = '';
      items[1].value = items[1].value + '元';
    },
  });
  consumeChart
    .line()
    .position('days*payableMoney')
    .color('#6edb8f')
    .shape('smooth')
    .size(4);
  consumeChart
    .area()
    .position('days*payableMoney')
    .color('l(90) 0:#6edb8f 1:#fff')
    .shape('smooth')
    .style({
      fillOpacity: 0.6,
    });
  // consumeChart.axis('payableMoney', false);
  consumeChart.render();
  return consumeChart;
}

Component({
  properties: {
    dataList: {
      type: Array,
      value: [],
      observer(newVal) {
        consumeChart && consumeChart.changeData(newVal);
      },
    },
    month: {
      type: String,
      value: '',
      observer(newVal) {
        month = newVal;
      },
    },
  },
  data: {
    opts: {
      onInit: initChart,
    },
  },
});
