"use strict";
var consumeChart = null;
var month = '';
function initChart(canvas, width, height, F2) {
    var data = [];
    consumeChart = new F2.Chart({
        el: canvas,
        width: width,
        height: height,
    });
    consumeChart.source(data, {
        days: {
            min: 1,
            max: 31,
        },
    });
    consumeChart.tooltip({
        showItemMarker: false,
        background: {
            radius: 2,
            fill: '#6edb8f',
            padding: [6, 10],
        },
        onShow: function (ev) {
            var items = ev.items;
            items[0].name = '';
            items[0].value = month + '-' + items[0].title;
            items[1].name = '';
            items[1].value = items[1].value + '元';
        },
    });
    consumeChart
        .line()
        .position('days*payableMoney')
        .color('#6edb8f')
        .shape('smooth')
        .size(4);
    consumeChart
        .area()
        .position('days*payableMoney')
        .color('l(90) 0:#6edb8f 1:#fff')
        .shape('smooth')
        .style({
        fillOpacity: 0.6,
    });
    consumeChart.render();
    return consumeChart;
}
Component({
    properties: {
        dataList: {
            type: Array,
            value: [],
            observer: function (newVal) {
                consumeChart && consumeChart.changeData(newVal);
            },
        },
        month: {
            type: String,
            value: '',
            observer: function (newVal) {
                month = newVal;
            },
        },
    },
    data: {
        opts: {
            onInit: initChart,
        },
    },
});
//# sourceMappingURL=data:application/json;base64,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