import { delay } from '../../../utils/util';

// pages/components/AreaSelect/AreaSelect.js
Component({
  properties: {
    placeholder: {
      type: String,
      value: '请选择',
    },
    range: {
      type: Array,
      value: [],
      observer(newVal) {
        this.setData({ filterList: newVal });
      },
    },
    rangeKey: {
      type: String,
      value: 'key',
    },
    value: {
      type: String,
      value: '',
      observer(newVal) {
        console.log(newVal);
        this.setData({ selected: newVal });
      },
    },
    mode: {
      type: String,
      value: 'selector',
    },
    methodName: {
      type: String,
      value: '',
    },
    showText: {
      type: String,
      value: '',
      observer(val) {
        console.log('in showText', val);
      },
    },
  },
  data: {
    showPickerView: false,
    selected: '',
    selectedIndex: '',
    filterList: [],
    inputValue: '',
  },
  methods: {
    inputClickHandle() {
      if (this.data.mode === 'page') {
        wx.navigateTo({
          url: `/pages/areaSelect/areaSelect?methodName=${this.data.methodName}&value=${this.data.value}`,
        });
      } else {
        let inputValue = '';
        if (this.data.selectedIndex || this.data.selectedIndex === 0) {
          inputValue = this.data.range[this.data.selectedIndex].areaName;
        }
        console.log(inputValue);
        this.setData!({
          showPickerView: !this.data.showPickerView,
          inputValue,
        });
      }
    },
    clearInputValue() {
      console.log('in clearInputValue');
      this.setData!({
        inputValue: '',
        selected: '',
        selectedIndex: '',
      });
    },
    innerClickHandle(e) {
      return false;
    },
    maskClickHandle(e) {
      this.setData({
        showPickerView: false,
      });
      return false;
    },
    inputHandle(e) {
      const { value } = e.detail;
      console.log(e, value);
      delay(() => {
        this.getFilterListByName(value);
      }, 500);
    },
    confirmHandle(e) {
      const { value } = e.detail;
      console.log(e, value);
      this.getFilterListByName(value);
    },
    getFilterListByName(name: string) {
      let filterList = [];
      if (name) {
        filterList = this.data.range.filter(item =>
          item[this.data.rangeKey].includes(name),
        );
      } else {
        filterList = this.data.range;
      }
      this.setData({
        filterList,
      });
    },
    bindPickerChange() {
      let value = this.data.selected;
      this.setData!({
        showPickerView: false,
      });
      this.triggerEvent('change', { value }, {});
    },
    selectedHandle(e) {
      const { value } = e.currentTarget.dataset;
      console.log(e, value);
      // if (this.data.selectedIndex === value) {
      //   this.setData({
      //     selected: '',
      //     selectedIndex: '',
      //   });
      // } else {
      //   this.setData({
      //     selected: this.data.filterList[value].id,
      //     selectedIndex: value,
      //   });
      // }
      let valueId = this.data.filterList[value].id;
      this.setData!({
        showPickerView: false,
        selected: this.data.filterList[value].id,
        selectedIndex: value,
      });
      this.triggerEvent('change', { value: valueId }, {});
    },
  },
});
