"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var fetch_1 = require("../../api/fetch");
var util_1 = require("../../utils/util");
Page({
    data: {
        selected: '',
        selectedIndex: '',
        areaList: [],
        filterList: [],
        methodName: '',
        inputValue: '',
    },
    onLoad: function (options) {
        console.log(options);
        var methodName = options.methodName, value = options.value;
        this.fetchAreaList();
        this.setData({
            methodName: methodName,
            selected: value,
        });
    },
    onShow: function () { },
    fetchAreaList: function () {
        var _this = this;
        fetch_1.baseFetch({
            url: '/dcxy/baseArea/queryAll',
        })
            .then(function (res) {
            if (res.data) {
                _this.setData({
                    areaList: res.data,
                    filterList: res.data,
                });
                if (_this.data.selected) {
                    var index = res.data.findIndex(function (item) { return item.id == _this.data.selected; });
                    console.log(_this.data.selected, index);
                    if (index > -1) {
                        _this.setData({
                            selectedIndex: index,
                            inputValue: res.data[index].areaName,
                        });
                    }
                }
            }
            else {
                _this.setData({
                    areaList: [],
                    filterList: [],
                });
            }
        })
            .catch(function (err) {
            console.log(err);
        });
    },
    inputHandle: function (e) {
        var _this = this;
        var value = e.detail.value;
        console.log(e, value);
        util_1.delay(function () {
            _this.getFilterListByName(value);
        }, 500);
    },
    confirmHandle: function (e) {
        var value = e.detail.value;
        console.log(e, value);
        this.getFilterListByName(value);
    },
    clearInputValue: function () {
        console.log('in clearInputValue');
        this.setData({
            inputValue: '',
            selected: '',
            selectedIndex: '',
        });
    },
    getFilterListByName: function (name) {
        var filterList = [];
        if (name) {
            filterList = this.data.areaList.filter(function (item) {
                return item['areaName'].includes(name);
            });
        }
        else {
            filterList = this.data.areaList;
        }
        this.setData({
            filterList: filterList,
        });
    },
    selectedHandle: function (e) {
        var value = e.currentTarget.dataset.value;
        console.log(e, value);
        var pages = getCurrentPages();
        var prevPage = pages[pages.length - 2];
        var entity = {
            id: this.data.filterList[value].id,
            name: this.data.filterList[value].areaName,
        };
        if (this.data.methodName && prevPage[this.data.methodName]) {
            prevPage[this.data.methodName](entity);
        }
        wx.navigateBack({ delta: 1 });
    },
    bindPickerChange: function () {
        var value = this.data.selected;
        var pages = getCurrentPages();
        var prevPage = pages[pages.length - 2];
        var entity = {};
        if (value) {
            entity = {
                id: value,
                name: this.data.filterList[this.data.selectedIndex].areaName,
            };
        }
        else {
            entity = { id: '', name: '' };
        }
        if (this.data.methodName && prevPage[this.data.methodName]) {
            prevPage[this.data.methodName](entity);
        }
        wx.navigateBack({ delta: 1 });
    },
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXJlYVNlbGVjdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImFyZWFTZWxlY3QudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSx5Q0FBNEM7QUFDNUMseUNBQXlDO0FBR3pDLElBQUksQ0FBQztJQUlILElBQUksRUFBRTtRQUNKLFFBQVEsRUFBRSxFQUFFO1FBQ1osYUFBYSxFQUFFLEVBQUU7UUFDakIsUUFBUSxFQUFFLEVBQUU7UUFDWixVQUFVLEVBQUUsRUFBRTtRQUNkLFVBQVUsRUFBRSxFQUFFO1FBQ2QsVUFBVSxFQUFFLEVBQUU7S0FDZjtJQUtELE1BQU0sRUFBRSxVQUFTLE9BQU87UUFDdEIsT0FBTyxDQUFDLEdBQUcsQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUNiLElBQUEsK0JBQVUsRUFBRSxxQkFBSyxDQUFhO1FBQ3RDLElBQUksQ0FBQyxhQUFhLEVBQUUsQ0FBQztRQUNyQixJQUFJLENBQUMsT0FBUSxDQUFDO1lBQ1osVUFBVSxZQUFBO1lBQ1YsUUFBUSxFQUFFLEtBQUs7U0FDaEIsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztJQUlELE1BQU0sRUFBRSxjQUFZLENBQUM7SUFDckIsYUFBYTtRQUFiLGlCQWdDQztRQS9CQyxpQkFBUyxDQUFDO1lBQ1IsR0FBRyxFQUFFLHlCQUF5QjtTQUMvQixDQUFDO2FBQ0MsSUFBSSxDQUFDLFVBQUEsR0FBRztZQUNQLEVBQUUsQ0FBQyxDQUFDLEdBQUcsQ0FBQyxJQUFJLENBQUMsQ0FBQyxDQUFDO2dCQUNiLEtBQUksQ0FBQyxPQUFRLENBQUM7b0JBQ1osUUFBUSxFQUFFLEdBQUcsQ0FBQyxJQUFJO29CQUNsQixVQUFVLEVBQUUsR0FBRyxDQUFDLElBQUk7aUJBQ3JCLENBQUMsQ0FBQztnQkFDSCxFQUFFLENBQUMsQ0FBQyxLQUFJLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxDQUFDLENBQUM7b0JBQ3ZCLElBQUksS0FBSyxHQUFHLEdBQUcsQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUM1QixVQUFBLElBQUksSUFBSSxPQUFBLElBQUksQ0FBQyxFQUFFLElBQUksS0FBSSxDQUFDLElBQUksQ0FBQyxRQUFRLEVBQTdCLENBQTZCLENBQ3RDLENBQUM7b0JBQ0YsT0FBTyxDQUFDLEdBQUcsQ0FBQyxLQUFJLENBQUMsSUFBSSxDQUFDLFFBQVEsRUFBRSxLQUFLLENBQUMsQ0FBQztvQkFDdkMsRUFBRSxDQUFDLENBQUMsS0FBSyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQzt3QkFDZixLQUFJLENBQUMsT0FBTyxDQUFDOzRCQUNYLGFBQWEsRUFBRSxLQUFLOzRCQUNwQixVQUFVLEVBQUUsR0FBRyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQyxRQUFRO3lCQUNyQyxDQUFDLENBQUM7b0JBQ0wsQ0FBQztnQkFDSCxDQUFDO1lBQ0gsQ0FBQztZQUFDLElBQUksQ0FBQyxDQUFDO2dCQUNOLEtBQUksQ0FBQyxPQUFRLENBQUM7b0JBQ1osUUFBUSxFQUFFLEVBQUU7b0JBQ1osVUFBVSxFQUFFLEVBQUU7aUJBQ2YsQ0FBQyxDQUFDO1lBQ0wsQ0FBQztRQUNILENBQUMsQ0FBQzthQUNELEtBQUssQ0FBQyxVQUFBLEdBQUc7WUFDUixPQUFPLENBQUMsR0FBRyxDQUFDLEdBQUcsQ0FBQyxDQUFDO1FBQ25CLENBQUMsQ0FBQyxDQUFDO0lBQ1AsQ0FBQztJQUNELFdBQVcsWUFBQyxDQUFDO1FBQWIsaUJBTUM7UUFMUyxJQUFBLHNCQUFLLENBQWM7UUFDM0IsT0FBTyxDQUFDLEdBQUcsQ0FBQyxDQUFDLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFDdEIsWUFBSyxDQUFDO1lBQ0osS0FBSSxDQUFDLG1CQUFtQixDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQ2xDLENBQUMsRUFBRSxHQUFHLENBQUMsQ0FBQztJQUNWLENBQUM7SUFDRCxhQUFhLFlBQUMsQ0FBQztRQUNMLElBQUEsc0JBQUssQ0FBYztRQUMzQixPQUFPLENBQUMsR0FBRyxDQUFDLENBQUMsRUFBRSxLQUFLLENBQUMsQ0FBQztRQUN0QixJQUFJLENBQUMsbUJBQW1CLENBQUMsS0FBSyxDQUFDLENBQUM7SUFDbEMsQ0FBQztJQUNELGVBQWU7UUFDYixPQUFPLENBQUMsR0FBRyxDQUFDLG9CQUFvQixDQUFDLENBQUM7UUFDbEMsSUFBSSxDQUFDLE9BQVEsQ0FBQztZQUNaLFVBQVUsRUFBRSxFQUFFO1lBQ2QsUUFBUSxFQUFFLEVBQUU7WUFDWixhQUFhLEVBQUUsRUFBRTtTQUNsQixDQUFDLENBQUM7SUFDTCxDQUFDO0lBQ0QsbUJBQW1CLFlBQUMsSUFBWTtRQUM5QixJQUFJLFVBQVUsR0FBRyxFQUFFLENBQUM7UUFDcEIsRUFBRSxDQUFDLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQztZQUNULFVBQVUsR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxNQUFNLENBQUMsVUFBQSxJQUFJO2dCQUN6QyxPQUFBLElBQUksQ0FBQyxVQUFVLENBQUMsQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDO1lBQS9CLENBQStCLENBQ2hDLENBQUM7UUFDSixDQUFDO1FBQUMsSUFBSSxDQUFDLENBQUM7WUFDTixVQUFVLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUM7UUFDbEMsQ0FBQztRQUNELElBQUksQ0FBQyxPQUFRLENBQUM7WUFDWixVQUFVLFlBQUE7U0FDWCxDQUFDLENBQUM7SUFDTCxDQUFDO0lBQ0QsY0FBYyxZQUFDLENBQUM7UUFDTixJQUFBLHFDQUFLLENBQTZCO1FBQzFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsQ0FBQyxFQUFFLEtBQUssQ0FBQyxDQUFDO1FBWXRCLElBQUksS0FBSyxHQUFHLGVBQWUsRUFBRSxDQUFDO1FBQzlCLElBQUksUUFBUSxHQUFHLEtBQUssQ0FBQyxLQUFLLENBQUMsTUFBTSxHQUFHLENBQUMsQ0FBQyxDQUFDO1FBQ3ZDLElBQUksTUFBTSxHQUFHO1lBQ1gsRUFBRSxFQUFFLElBQUksQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxDQUFDLEVBQUU7WUFDbEMsSUFBSSxFQUFFLElBQUksQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLEtBQUssQ0FBQyxDQUFDLFFBQVE7U0FDM0MsQ0FBQztRQUVGLEVBQUUsQ0FBQyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsVUFBVSxJQUFJLFFBQVEsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxDQUFDLENBQUMsQ0FBQztZQUMzRCxRQUFRLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsQ0FBQyxNQUFNLENBQUMsQ0FBQztRQUN6QyxDQUFDO1FBQ0QsRUFBRSxDQUFDLFlBQVksQ0FBQyxFQUFFLEtBQUssRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDO0lBQ2hDLENBQUM7SUFDRCxnQkFBZ0I7UUFDZCxJQUFJLEtBQUssR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQztRQUsvQixJQUFJLEtBQUssR0FBRyxlQUFlLEVBQUUsQ0FBQztRQUM5QixJQUFJLFFBQVEsR0FBRyxLQUFLLENBQUMsS0FBSyxDQUFDLE1BQU0sR0FBRyxDQUFDLENBQUMsQ0FBQztRQUN2QyxJQUFJLE1BQU0sR0FBRyxFQUFFLENBQUM7UUFDaEIsRUFBRSxDQUFDLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQztZQUNWLE1BQU0sR0FBRztnQkFDUCxFQUFFLEVBQUUsS0FBSztnQkFDVCxJQUFJLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxVQUFVLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsQ0FBQyxRQUFRO2FBQzdELENBQUM7UUFDSixDQUFDO1FBQUMsSUFBSSxDQUFDLENBQUM7WUFDTixNQUFNLEdBQUcsRUFBRSxFQUFFLEVBQUUsRUFBRSxFQUFFLElBQUksRUFBRSxFQUFFLEVBQUUsQ0FBQztRQUNoQyxDQUFDO1FBQ0QsRUFBRSxDQUFDLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxVQUFVLElBQUksUUFBUSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsVUFBVSxDQUFDLENBQUMsQ0FBQyxDQUFDO1lBQzNELFFBQVEsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxDQUFDLE1BQU0sQ0FBQyxDQUFDO1FBQ3pDLENBQUM7UUFDRCxFQUFFLENBQUMsWUFBWSxDQUFDLEVBQUUsS0FBSyxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUM7SUFDaEMsQ0FBQztDQUNGLENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IGJhc2VGZXRjaCB9IGZyb20gJy4uLy4uL2FwaS9mZXRjaCc7XG5pbXBvcnQgeyBkZWxheSB9IGZyb20gJy4uLy4uL3V0aWxzL3V0aWwnO1xuXG4vLyBtaW5pcHJvZ3JhbS9wYWdlcy9hcmVhU2VsZWN0L2FyZWFTZWxlY3QuanNcblBhZ2Uoe1xuICAvKipcbiAgICog6aG16Z2i55qE5Yid5aeL5pWw5o2uXG4gICAqL1xuICBkYXRhOiB7XG4gICAgc2VsZWN0ZWQ6ICcnLFxuICAgIHNlbGVjdGVkSW5kZXg6ICcnLFxuICAgIGFyZWFMaXN0OiBbXSxcbiAgICBmaWx0ZXJMaXN0OiBbXSxcbiAgICBtZXRob2ROYW1lOiAnJyxcbiAgICBpbnB1dFZhbHVlOiAnJyxcbiAgfSxcblxuICAvKipcbiAgICog55Sf5ZG95ZGo5pyf5Ye95pWwLS3nm5HlkKzpobXpnaLliqDovb1cbiAgICovXG4gIG9uTG9hZDogZnVuY3Rpb24ob3B0aW9ucykge1xuICAgIGNvbnNvbGUubG9nKG9wdGlvbnMpO1xuICAgIGNvbnN0IHsgbWV0aG9kTmFtZSwgdmFsdWUgfSA9IG9wdGlvbnM7XG4gICAgdGhpcy5mZXRjaEFyZWFMaXN0KCk7XG4gICAgdGhpcy5zZXREYXRhISh7XG4gICAgICBtZXRob2ROYW1lLFxuICAgICAgc2VsZWN0ZWQ6IHZhbHVlLFxuICAgIH0pO1xuICB9LFxuICAvKipcbiAgICog55Sf5ZG95ZGo5pyf5Ye95pWwLS3nm5HlkKzpobXpnaLmmL7npLpcbiAgICovXG4gIG9uU2hvdzogZnVuY3Rpb24oKSB7fSxcbiAgZmV0Y2hBcmVhTGlzdCgpIHtcbiAgICBiYXNlRmV0Y2goe1xuICAgICAgdXJsOiAnL2RjeHkvYmFzZUFyZWEvcXVlcnlBbGwnLFxuICAgIH0pXG4gICAgICAudGhlbihyZXMgPT4ge1xuICAgICAgICBpZiAocmVzLmRhdGEpIHtcbiAgICAgICAgICB0aGlzLnNldERhdGEhKHtcbiAgICAgICAgICAgIGFyZWFMaXN0OiByZXMuZGF0YSxcbiAgICAgICAgICAgIGZpbHRlckxpc3Q6IHJlcy5kYXRhLFxuICAgICAgICAgIH0pO1xuICAgICAgICAgIGlmICh0aGlzLmRhdGEuc2VsZWN0ZWQpIHtcbiAgICAgICAgICAgIGxldCBpbmRleCA9IHJlcy5kYXRhLmZpbmRJbmRleChcbiAgICAgICAgICAgICAgaXRlbSA9PiBpdGVtLmlkID09IHRoaXMuZGF0YS5zZWxlY3RlZCxcbiAgICAgICAgICAgICk7XG4gICAgICAgICAgICBjb25zb2xlLmxvZyh0aGlzLmRhdGEuc2VsZWN0ZWQsIGluZGV4KTtcbiAgICAgICAgICAgIGlmIChpbmRleCA+IC0xKSB7XG4gICAgICAgICAgICAgIHRoaXMuc2V0RGF0YSh7XG4gICAgICAgICAgICAgICAgc2VsZWN0ZWRJbmRleDogaW5kZXgsXG4gICAgICAgICAgICAgICAgaW5wdXRWYWx1ZTogcmVzLmRhdGFbaW5kZXhdLmFyZWFOYW1lLFxuICAgICAgICAgICAgICB9KTtcbiAgICAgICAgICAgIH1cbiAgICAgICAgICB9XG4gICAgICAgIH0gZWxzZSB7XG4gICAgICAgICAgdGhpcy5zZXREYXRhISh7XG4gICAgICAgICAgICBhcmVhTGlzdDogW10sXG4gICAgICAgICAgICBmaWx0ZXJMaXN0OiBbXSxcbiAgICAgICAgICB9KTtcbiAgICAgICAgfVxuICAgICAgfSlcbiAgICAgIC5jYXRjaChlcnIgPT4ge1xuICAgICAgICBjb25zb2xlLmxvZyhlcnIpO1xuICAgICAgfSk7XG4gIH0sXG4gIGlucHV0SGFuZGxlKGUpIHtcbiAgICBjb25zdCB7IHZhbHVlIH0gPSBlLmRldGFpbDtcbiAgICBjb25zb2xlLmxvZyhlLCB2YWx1ZSk7XG4gICAgZGVsYXkoKCkgPT4ge1xuICAgICAgdGhpcy5nZXRGaWx0ZXJMaXN0QnlOYW1lKHZhbHVlKTtcbiAgICB9LCA1MDApO1xuICB9LFxuICBjb25maXJtSGFuZGxlKGUpIHtcbiAgICBjb25zdCB7IHZhbHVlIH0gPSBlLmRldGFpbDtcbiAgICBjb25zb2xlLmxvZyhlLCB2YWx1ZSk7XG4gICAgdGhpcy5nZXRGaWx0ZXJMaXN0QnlOYW1lKHZhbHVlKTtcbiAgfSxcbiAgY2xlYXJJbnB1dFZhbHVlKCkge1xuICAgIGNvbnNvbGUubG9nKCdpbiBjbGVhcklucHV0VmFsdWUnKTtcbiAgICB0aGlzLnNldERhdGEhKHtcbiAgICAgIGlucHV0VmFsdWU6ICcnLFxuICAgICAgc2VsZWN0ZWQ6ICcnLFxuICAgICAgc2VsZWN0ZWRJbmRleDogJycsXG4gICAgfSk7XG4gIH0sXG4gIGdldEZpbHRlckxpc3RCeU5hbWUobmFtZTogc3RyaW5nKSB7XG4gICAgbGV0IGZpbHRlckxpc3QgPSBbXTtcbiAgICBpZiAobmFtZSkge1xuICAgICAgZmlsdGVyTGlzdCA9IHRoaXMuZGF0YS5hcmVhTGlzdC5maWx0ZXIoaXRlbSA9PlxuICAgICAgICBpdGVtWydhcmVhTmFtZSddLmluY2x1ZGVzKG5hbWUpLFxuICAgICAgKTtcbiAgICB9IGVsc2Uge1xuICAgICAgZmlsdGVyTGlzdCA9IHRoaXMuZGF0YS5hcmVhTGlzdDtcbiAgICB9XG4gICAgdGhpcy5zZXREYXRhISh7XG4gICAgICBmaWx0ZXJMaXN0LFxuICAgIH0pO1xuICB9LFxuICBzZWxlY3RlZEhhbmRsZShlKSB7XG4gICAgY29uc3QgeyB2YWx1ZSB9ID0gZS5jdXJyZW50VGFyZ2V0LmRhdGFzZXQ7XG4gICAgY29uc29sZS5sb2coZSwgdmFsdWUpO1xuICAgIC8vIGlmICh0aGlzLmRhdGEuc2VsZWN0ZWRJbmRleCA9PT0gdmFsdWUpIHtcbiAgICAvLyAgIHRoaXMuc2V0RGF0YSh7XG4gICAgLy8gICAgIHNlbGVjdGVkOiAnJyxcbiAgICAvLyAgICAgc2VsZWN0ZWRJbmRleDogJycsXG4gICAgLy8gICB9KTtcbiAgICAvLyB9IGVsc2Uge1xuICAgIC8vICAgdGhpcy5zZXREYXRhKHtcbiAgICAvLyAgICAgc2VsZWN0ZWQ6IHRoaXMuZGF0YS5maWx0ZXJMaXN0W3ZhbHVlXS5pZCxcbiAgICAvLyAgICAgc2VsZWN0ZWRJbmRleDogdmFsdWUsXG4gICAgLy8gICB9KTtcbiAgICAvLyB9XG4gICAgdmFyIHBhZ2VzID0gZ2V0Q3VycmVudFBhZ2VzKCk7XG4gICAgdmFyIHByZXZQYWdlID0gcGFnZXNbcGFnZXMubGVuZ3RoIC0gMl07IC8v5LiK5LiA5Liq6aG16Z2iXG4gICAgbGV0IGVudGl0eSA9IHtcbiAgICAgIGlkOiB0aGlzLmRhdGEuZmlsdGVyTGlzdFt2YWx1ZV0uaWQsXG4gICAgICBuYW1lOiB0aGlzLmRhdGEuZmlsdGVyTGlzdFt2YWx1ZV0uYXJlYU5hbWUsXG4gICAgfTtcblxuICAgIGlmICh0aGlzLmRhdGEubWV0aG9kTmFtZSAmJiBwcmV2UGFnZVt0aGlzLmRhdGEubWV0aG9kTmFtZV0pIHtcbiAgICAgIHByZXZQYWdlW3RoaXMuZGF0YS5tZXRob2ROYW1lXShlbnRpdHkpO1xuICAgIH1cbiAgICB3eC5uYXZpZ2F0ZUJhY2soeyBkZWx0YTogMSB9KTtcbiAgfSxcbiAgYmluZFBpY2tlckNoYW5nZSgpIHtcbiAgICBsZXQgdmFsdWUgPSB0aGlzLmRhdGEuc2VsZWN0ZWQ7XG4gICAgLy8gdGhpcy5zZXREYXRhISh7XG4gICAgLy8gICBzaG93UGlja2VyVmlldzogZmFsc2UsXG4gICAgLy8gfSk7XG4gICAgLy8gdGhpcy50cmlnZ2VyRXZlbnQoJ2NoYW5nZScsIHsgdmFsdWUgfSwge30pO1xuICAgIHZhciBwYWdlcyA9IGdldEN1cnJlbnRQYWdlcygpO1xuICAgIHZhciBwcmV2UGFnZSA9IHBhZ2VzW3BhZ2VzLmxlbmd0aCAtIDJdOyAvL+S4iuS4gOS4qumhtemdolxuICAgIGxldCBlbnRpdHkgPSB7fTtcbiAgICBpZiAodmFsdWUpIHtcbiAgICAgIGVudGl0eSA9IHtcbiAgICAgICAgaWQ6IHZhbHVlLFxuICAgICAgICBuYW1lOiB0aGlzLmRhdGEuZmlsdGVyTGlzdFt0aGlzLmRhdGEuc2VsZWN0ZWRJbmRleF0uYXJlYU5hbWUsXG4gICAgICB9O1xuICAgIH0gZWxzZSB7XG4gICAgICBlbnRpdHkgPSB7IGlkOiAnJywgbmFtZTogJycgfTtcbiAgICB9XG4gICAgaWYgKHRoaXMuZGF0YS5tZXRob2ROYW1lICYmIHByZXZQYWdlW3RoaXMuZGF0YS5tZXRob2ROYW1lXSkge1xuICAgICAgcHJldlBhZ2VbdGhpcy5kYXRhLm1ldGhvZE5hbWVdKGVudGl0eSk7XG4gICAgfVxuICAgIHd4Lm5hdmlnYXRlQmFjayh7IGRlbHRhOiAxIH0pO1xuICB9LFxufSk7XG4iXX0=