// custom-tab-bar/index.ts
Component({
  /**
   * 组件的属性列表
   */
  properties: {
    checked: { type: Number, value: 0 },
    listData: { type: Array, value: [] },
  },
  lifetimes: {
    attached: function () {
      // 在组件实例进入页面节点树时执行
      if (this.data.pagePath === 'home') {
        this.setData({
          index: 0,
        });
      } else if (this.data.pagePath === 'report') {
        this.setData({
          index: 1,
        });
      }
    },
    detached: function () {
      // 在组件实例被从页面节点树移除时执行
    },
  },
  /**
   * 组件的初始数据
   */
  data: {

  },

  /**
   * 组件的方法列表
   */
  methods: {
    clickHandle(e) {
      let { path, index } = e.currentTarget.dataset;
      let myEventDetail = {
        path, index,
      } // detail对象，提供给事件监听函数
      this.triggerEvent('customevent', myEventDetail)
    }
  },
});
