import { successCode, logoutode, masterUrl } from '../config/constants';
import { IMyApp } from '../app';
const app = getApp<IMyApp>();

const fetch = (req: wx.RequestOption) =>
  new Promise((resolve, reject) => {
    const token = app.globalData.token;
    wx.request({
      ...req,
      header: token
        ? {
            token,
            ...req.header,
          }
        : req.header,

      success: resolve,
      fail: reject,
    });
  }).then((res: wx.RequestSuccessCallbackResult) => {
    const { code, ...otherkeys } = res.data;
    if (code === successCode) {
      console.log(res);
      if (res.header['Set-Cookie'])
        return {
          header: res.header,
          data: otherkeys,
        };
      return otherkeys;
    } else if (code === logoutode) {
      app.resetUserinfo();
      wx.reLaunch({
        url: '/pages/index/index',
      });
      throw {
        errMsg: res.data.msg || '网络异常',
      };
    } else {
      throw {
        errMsg: res.data.msg || '网络异常',
      };
    }
  });

export const systemFetch = (req: wx.RequestOption) =>
  fetch({ ...req, url: masterUrl.SYSTEM_SERVER_URL + req.url });
export const statisticsFetch = (req: wx.RequestOption) =>
  fetch({ ...req, url: masterUrl.STATISTICS_SERVER_URL + req.url });
export const customerFetch = (req: wx.RequestOption) =>
  fetch({ ...req, url: masterUrl.CUSTOMER_SERVER_URL + req.url });
export const baseFetch = (req: wx.RequestOption) =>
  fetch({ ...req, url: masterUrl.BASE_SERVER_URL + req.url });
export default fetch;
